/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gml3.v3_2;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.net.URL;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.commons.io.FileUtils;
import org.eclipse.xsd.XSDSchema;
import org.geotools.api.feature.simple.SimpleFeature;
import org.geotools.api.referencing.crs.CoordinateReferenceSystem;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.FeatureIterator;
import org.geotools.gml3.v3_2.GML;
import org.geotools.gml3.v3_2.GMLConfiguration;
import org.geotools.referencing.CRS;
import org.geotools.util.URLs;
import org.geotools.xsd.Configuration;
import org.geotools.xsd.Parser;
import org.junit.Assert;
import org.junit.Test;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.jts.geom.Point;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class GMLParsingTest {
    @Test
    public void testGML() throws Exception {
        XSDSchema gml = GML.getInstance().getSchema();
        Assert.assertFalse((boolean)gml.getTypeDefinitions().isEmpty());
    }

    @Test
    public void testParseFeatureCollection() throws Exception {
        File schema = File.createTempFile("test", "xsd");
        schema.deleteOnExit();
        FileUtils.copyURLToFile((URL)this.getClass().getResource("test.xsd"), (File)schema);
        Document dom = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(this.getClass().getResourceAsStream("test.xml"));
        URL schemaURL = URLs.fileToUrl((File)schema.getAbsoluteFile());
        dom.getDocumentElement().setAttribute("xsi:schemaLocation", "http://www.geotools.org/test " + schemaURL.getFile());
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        TransformerFactory.newInstance().newTransformer().transform(new DOMSource(dom), new StreamResult(out));
        GMLConfiguration config = new GMLConfiguration();
        Parser p = new Parser((Configuration)config);
        Object o = p.parse((InputStream)new ByteArrayInputStream(out.toByteArray()));
        Assert.assertTrue((boolean)(o instanceof FeatureCollection));
        FeatureCollection features = (FeatureCollection)o;
        Assert.assertEquals((long)3L, (long)features.size());
        try (FeatureIterator fi = features.features();){
            for (int i = 0; i < 3; ++i) {
                Assert.assertTrue((boolean)fi.hasNext());
                SimpleFeature f = (SimpleFeature)fi.next();
                Assert.assertTrue((boolean)(f.getDefaultGeometry() instanceof Point));
                Point point = (Point)f.getDefaultGeometry();
                Assert.assertEquals((double)((double)i / 1.0), (double)point.getX(), (double)0.1);
                Assert.assertEquals((double)((double)i / 1.0), (double)point.getX(), (double)0.1);
                Assert.assertEquals((Object)i, (Object)f.getAttribute("count"));
            }
        }
    }

    private static CoordinateReferenceSystem parsePointSrsname(String srsName) {
        Parser parser = new Parser((Configuration)new GMLConfiguration());
        String text = "<gml:Point xmlns:gml=\"http://www.opengis.net/gml/3.2\" srsName=\"" + srsName + "\"><gml:pos>1 2</gml:pos></gml:Point>";
        try {
            Point point = (Point)parser.parse((Reader)new StringReader(text));
            return (CoordinateReferenceSystem)point.getUserData();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Test
    public void testParseEpsgSrsname() throws Exception {
        Assert.assertEquals((Object)CRS.decode((String)"EPSG:4326"), (Object)GMLParsingTest.parsePointSrsname("EPSG:4326"));
    }

    @Test
    public void testParseOgcHttpUrlSrsname() throws Exception {
        Assert.assertEquals((Object)CRS.decode((String)"EPSG:4326"), (Object)GMLParsingTest.parsePointSrsname("http://www.opengis.net/gml/srs/epsg.xml#4326"));
    }

    @Test
    public void testParseOgcUrnExperimentalSrsname() throws Exception {
        Assert.assertEquals((Object)CRS.decode((String)"EPSG:4326"), (Object)GMLParsingTest.parsePointSrsname("urn:x-ogc:def:crs:EPSG::4326"));
    }

    @Test
    public void testParseOgcUrnSrsname() throws Exception {
        Assert.assertEquals((Object)CRS.decode((String)"EPSG:4326"), (Object)GMLParsingTest.parsePointSrsname("urn:ogc:def:crs:EPSG::4326"));
    }

    @Test
    public void testParseOgcHttpUriSrsname() throws Exception {
        Assert.assertEquals((Object)CRS.decode((String)"EPSG:4326"), (Object)GMLParsingTest.parsePointSrsname("http://www.opengis.net/def/crs/EPSG/0/4326"));
    }

    @Test
    public void testCoordinateList() throws IOException, SAXException, ParserConfigurationException {
        GMLConfiguration gml = new GMLConfiguration(true);
        Parser p = new Parser((Configuration)gml);
        Object multiSurface = p.parse(this.getClass().getResourceAsStream("surfacePatches.xml"));
        Assert.assertFalse((boolean)(multiSurface instanceof String));
        Assert.assertTrue((String)"wrong element type", (boolean)(multiSurface instanceof MultiPolygon));
        MultiPolygon geom = (MultiPolygon)multiSurface;
        Assert.assertFalse((boolean)geom.isEmpty());
    }

    @Test
    public void testSurfacememberPatches() throws IOException, SAXException, ParserConfigurationException {
        GMLConfiguration gml = new GMLConfiguration(true);
        Parser p = new Parser((Configuration)gml);
        Object multiSurface = p.parse(this.getClass().getResourceAsStream("surfacememberPatches.xml"));
        Assert.assertFalse((boolean)(multiSurface instanceof String));
        Assert.assertTrue((String)"wrong element type", (boolean)(multiSurface instanceof MultiPolygon));
        MultiPolygon geom = (MultiPolygon)multiSurface;
        Assert.assertFalse((boolean)geom.isEmpty());
    }

    @Test
    public void testNestedInteriors() throws IOException, SAXException, ParserConfigurationException {
        GMLConfiguration gml = new GMLConfiguration(true);
        Parser p = new Parser((Configuration)gml);
        Object multiSurface = p.parse(this.getClass().getResourceAsStream("nestedInteriors.xml"));
        Assert.assertFalse((boolean)(multiSurface instanceof String));
        Assert.assertTrue((String)"wrong element type", (boolean)(multiSurface instanceof MultiPolygon));
        MultiPolygon geom = (MultiPolygon)multiSurface;
        Assert.assertFalse((boolean)geom.isEmpty());
    }
}

