/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gml3.simple;

import org.geotools.geometry.jts.WKTReader2;
import org.geotools.gml3.simple.GeometryEncoderTestSupport;
import org.geotools.gml3.simple.MultiPointEncoder;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Test;
import org.locationtech.jts.geom.MultiPoint;
import org.w3c.dom.Document;

public class MultiPointTest
extends GeometryEncoderTestSupport {
    @Test
    public void testEncodeMultiPoint() throws Exception {
        MultiPointEncoder encoder = new MultiPointEncoder(this.gtEncoder, "gml", "http://www.opengis.net/gml");
        MultiPoint geometry = (MultiPoint)new WKTReader2().read("MULTIPOINT(0 0, 1 1)");
        Document doc = this.encode(encoder, geometry, "points");
        MatcherAssert.assertThat((Object)doc, (Matcher)this.hasXPath("/gml:MultiPoint/gml:pointMember[1]/gml:Point/gml:pos", CoreMatchers.equalTo((Object)"0 0")));
        MatcherAssert.assertThat((Object)doc, (Matcher)this.hasXPath("/gml:MultiPoint/gml:pointMember[2]/gml:Point/gml:pos", CoreMatchers.equalTo((Object)"1 1")));
        MatcherAssert.assertThat((Object)doc, (Matcher)this.hasXPath("/gml:MultiPoint/@gml:id", CoreMatchers.equalTo((Object)"points")));
        MatcherAssert.assertThat((Object)doc, (Matcher)this.hasXPath("/gml:MultiPoint/gml:pointMember[1]/gml:Point/@gml:id", CoreMatchers.equalTo((Object)"points.1")));
        MatcherAssert.assertThat((Object)doc, (Matcher)this.hasXPath("/gml:MultiPoint/gml:pointMember[2]/gml:Point/@gml:id", CoreMatchers.equalTo((Object)"points.2")));
    }

    @Test
    public void testEncodeMultiPointNoGmlId() throws Exception {
        MultiPointEncoder encoder = new MultiPointEncoder(this.gtEncoder, "gml", "http://www.opengis.net/gml", false);
        MultiPoint geometry = (MultiPoint)new WKTReader2().read("MULTIPOINT(0 0, 1 1)");
        Document doc = this.encode(encoder, geometry, "points");
        MatcherAssert.assertThat((Object)doc, (Matcher)this.hasXPath("count(//gml:MultiPoint/gml:pointMember/gml:Point/@gml:id)", CoreMatchers.equalTo((Object)"0")));
    }
}

