/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gml3.simple;

import org.geotools.geometry.jts.LiteCoordinateSequence;
import org.geotools.gml3.simple.GeometryEncoderTestSupport;
import org.geotools.gml3.simple.LineStringEncoder;
import org.geotools.gml3.simple.PointEncoder;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Test;
import org.locationtech.jts.geom.CoordinateSequence;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.Point;
import org.w3c.dom.Document;

public final class LineStringMeasuresTest
extends GeometryEncoderTestSupport {
    @Test
    public void testEncodeLineMFromLiteCS() throws Exception {
        LiteCoordinateSequence cs = new LiteCoordinateSequence(new double[]{0.0, 1.0, -1.5, 3.0, 4.0, -2.5}, 3, 1);
        LineString geometry = new GeometryFactory().createLineString((CoordinateSequence)cs);
        LineStringEncoder encoder = new LineStringEncoder(this.gtEncoder, "gml", "http://www.opengis.net/gml");
        Document document = this.encode(encoder, geometry, "line");
        MatcherAssert.assertThat((Object)document, (Matcher)this.hasXPath("//gml:posList", CoreMatchers.equalTo((Object)"0 1 -1.5 3 4 -2.5")));
    }

    @Test
    public void testEncodeLineMFromLiteCSNoMeasuresEncoded() throws Exception {
        LiteCoordinateSequence cs = new LiteCoordinateSequence(new double[]{0.0, 1.0, -1.5, 3.0, 4.0, -2.5}, 3, 1);
        LineString geometry = new GeometryFactory().createLineString((CoordinateSequence)cs);
        LineStringEncoder encoder = new LineStringEncoder(this.gtEncoder, "gml", "http://www.opengis.net/gml");
        Document document = this.encode(encoder, geometry, false, "line");
        MatcherAssert.assertThat((Object)document, (Matcher)this.hasXPath("//gml:posList", CoreMatchers.equalTo((Object)"0 1 3 4")));
    }

    @Test
    public void testEncodePointMFromLiteCS() throws Exception {
        LiteCoordinateSequence cs = new LiteCoordinateSequence(new double[]{0.0, 1.0, -1.5}, 3, 1);
        Point geometry = new GeometryFactory().createPoint((CoordinateSequence)cs);
        PointEncoder encoder = new PointEncoder(this.gtEncoder, "gml", "http://www.opengis.net/gml");
        Document document = this.encode(encoder, geometry, "line");
        MatcherAssert.assertThat((Object)document, (Matcher)this.hasXPath("//gml:pos", CoreMatchers.equalTo((Object)"0 1 -1.5")));
    }

    @Test
    public void testEncodePointMFromLiteCSNoMeasuresEncoded() throws Exception {
        LiteCoordinateSequence cs = new LiteCoordinateSequence(new double[]{0.0, 1.0, -1.5}, 3, 1);
        Point geometry = new GeometryFactory().createPoint((CoordinateSequence)cs);
        PointEncoder encoder = new PointEncoder(this.gtEncoder, "gml", "http://www.opengis.net/gml");
        Document document = this.encode(encoder, geometry, false, "line");
        MatcherAssert.assertThat((Object)document, (Matcher)this.hasXPath("//gml:pos", CoreMatchers.equalTo((Object)"0 1")));
    }

    @Test
    public void testEncodeLineZMFromLiteCS() throws Exception {
        LiteCoordinateSequence cs = new LiteCoordinateSequence(new double[]{0.0, 1.0, 10.0, -1.5, 3.0, 4.0, 15.0, -2.5}, 4, 1);
        LineString geometry = new GeometryFactory().createLineString((CoordinateSequence)cs);
        LineStringEncoder encoder = new LineStringEncoder(this.gtEncoder, "gml", "http://www.opengis.net/gml");
        Document document = this.encode(encoder, geometry, "line");
        MatcherAssert.assertThat((Object)document, (Matcher)this.hasXPath("//gml:posList", CoreMatchers.equalTo((Object)"0 1 10 -1.5 3 4 15 -2.5")));
    }

    @Test
    public void testEncodeLineZMFromLiteCSNoMeasuresEncoded() throws Exception {
        LiteCoordinateSequence cs = new LiteCoordinateSequence(new double[]{0.0, 1.0, 10.0, -1.5, 3.0, 4.0, 15.0, -2.5}, 4, 1);
        LineString geometry = new GeometryFactory().createLineString((CoordinateSequence)cs);
        LineStringEncoder encoder = new LineStringEncoder(this.gtEncoder, "gml", "http://www.opengis.net/gml");
        Document document = this.encode(encoder, geometry, false, "line");
        MatcherAssert.assertThat((Object)document, (Matcher)this.hasXPath("//gml:posList", CoreMatchers.equalTo((Object)"0 1 10 3 4 15")));
    }

    @Test
    public void testEncodePointZMFromLiteCS() throws Exception {
        LiteCoordinateSequence cs = new LiteCoordinateSequence(new double[]{0.0, 1.0, 10.0, -1.5}, 4, 1);
        Point geometry = new GeometryFactory().createPoint((CoordinateSequence)cs);
        PointEncoder encoder = new PointEncoder(this.gtEncoder, "gml", "http://www.opengis.net/gml");
        Document document = this.encode(encoder, geometry, "line");
        MatcherAssert.assertThat((Object)document, (Matcher)this.hasXPath("//gml:pos", CoreMatchers.equalTo((Object)"0 1 10 -1.5")));
    }

    @Test
    public void testEncodePointZMFromLiteCSNoMeasuresEncoded() throws Exception {
        LiteCoordinateSequence cs = new LiteCoordinateSequence(new double[]{0.0, 1.0, 10.0, -1.5}, 4, 1);
        Point geometry = new GeometryFactory().createPoint((CoordinateSequence)cs);
        PointEncoder encoder = new PointEncoder(this.gtEncoder, "gml", "http://www.opengis.net/gml");
        Document document = this.encode(encoder, geometry, false, "line");
        MatcherAssert.assertThat((Object)document, (Matcher)this.hasXPath("//gml:pos", CoreMatchers.equalTo((Object)"0 1 10")));
    }
}

