/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gml3.simple;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Properties;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.sax.TransformerHandler;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.geotools.gml2.simple.GMLWriter;
import org.geotools.gml2.simple.GeometryEncoder;
import org.geotools.gml3.GML3TestSupport;
import org.geotools.xsd.Encoder;
import org.junit.Before;
import org.locationtech.jts.geom.Geometry;
import org.w3c.dom.Document;
import org.xml.sax.ContentHandler;
import org.xml.sax.helpers.AttributesImpl;

public abstract class GeometryEncoderTestSupport
extends GML3TestSupport {
    static final String INDENT_AMOUNT_KEY = "{http://xml.apache.org/xslt}indent-amount";
    protected Encoder gtEncoder;

    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.gtEncoder = new Encoder(this.createConfiguration());
    }

    protected <T extends Geometry> Document encode(GeometryEncoder<T> encoder, T geometry) throws Exception {
        return this.encode(encoder, geometry, null);
    }

    protected <T extends Geometry> Document encode(GeometryEncoder<T> encoder, T geometry, String gmlId) throws Exception {
        return this.encode(encoder, geometry, true, gmlId, 6, false, false);
    }

    protected <T extends Geometry> Document encode(GeometryEncoder<T> encoder, T geometry, boolean encodeMeasures, String gmlId) throws Exception {
        return this.encode(encoder, geometry, encodeMeasures, gmlId, 6, false, false);
    }

    protected <T extends Geometry> Document encode(GeometryEncoder<T> encoder, T geometry, boolean encodeMeasures, String gmlId, int numDecimals, boolean decimalEncoding, boolean padWithZeros) throws Exception {
        TransformerHandler xmls;
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        SAXTransformerFactory txFactory = (SAXTransformerFactory)SAXTransformerFactory.newInstance();
        try {
            xmls = txFactory.newTransformerHandler();
        }
        catch (TransformerConfigurationException e) {
            throw new IOException(e);
        }
        Properties outputProps = new Properties();
        outputProps.setProperty(INDENT_AMOUNT_KEY, "2");
        xmls.getTransformer().setOutputProperties(outputProps);
        xmls.getTransformer().setOutputProperty("method", "xml");
        xmls.setResult(new StreamResult(out));
        GMLWriter handler = new GMLWriter((ContentHandler)xmls, this.gtEncoder.getNamespaces(), numDecimals, decimalEncoding, padWithZeros, "gml", encodeMeasures);
        handler.startDocument();
        handler.startPrefixMapping("gml", "http://www.opengis.net/gml");
        handler.endPrefixMapping("gml");
        encoder.encode(geometry, new AttributesImpl(), handler, gmlId);
        handler.endDocument();
        ByteArrayInputStream in = new ByteArrayInputStream(out.toByteArray());
        DOMResult result = new DOMResult();
        Transformer tx = TransformerFactory.newInstance().newTransformer();
        tx.transform(new StreamSource(in), result);
        Document d = (Document)result.getNode();
        return d;
    }
}

