/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gml3.simple;

import org.geotools.geometry.jts.WKTReader2;
import org.geotools.gml3.simple.CurveEncoder;
import org.geotools.gml3.simple.GeometryEncoderTestSupport;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Test;
import org.locationtech.jts.geom.LineString;
import org.w3c.dom.Document;

public class CurveEncoderTest
extends GeometryEncoderTestSupport {
    @Test
    public void testEncodeCircle() throws Exception {
        CurveEncoder encoder = new CurveEncoder(this.gtEncoder, "gml", "http://www.opengis.net/gml");
        LineString geometry = (LineString)new WKTReader2().read("CIRCULARSTRING(-10 0, -8 2, -6 0, -8 -2, -10 0)");
        Document doc = this.encode(encoder, geometry, "circle.abc");
        MatcherAssert.assertThat((Object)doc, (Matcher)this.hasXPath("count(//gml:Curve/gml:segments/gml:ArcString/gml:posList)", CoreMatchers.equalTo((Object)"1")));
        MatcherAssert.assertThat((Object)doc, (Matcher)this.hasXPath("//gml:Curve/gml:segments/gml:ArcString/@interpolation", CoreMatchers.equalTo((Object)"circularArc3Points")));
        MatcherAssert.assertThat((Object)doc, (Matcher)this.hasXPath("//gml:Curve/gml:segments/gml:ArcString/gml:posList", CoreMatchers.equalTo((Object)"-10 0 -8 2 -6 0 -8 -2 -10 0")));
        MatcherAssert.assertThat((Object)doc, (Matcher)this.hasXPath("//gml:Curve/@gml:id", CoreMatchers.equalTo((Object)"circle.abc")));
    }

    @Test
    public void testEncodeCompound() throws Exception {
        CurveEncoder encoder = new CurveEncoder(this.gtEncoder, "gml", "http://www.opengis.net/gml");
        LineString geometry = (LineString)new WKTReader2().read("COMPOUNDCURVE(CIRCULARSTRING(0 0, 2 0, 2 1, 2 3, 4 3),(4 3, 4 5, 1 4, 0 0))");
        Document doc = this.encode(encoder, geometry, "compound.3");
        MatcherAssert.assertThat((Object)doc, (Matcher)this.hasXPath("count(//gml:Curve//gml:segments/*)", CoreMatchers.equalTo((Object)"2")));
        MatcherAssert.assertThat((Object)doc, (Matcher)this.hasXPath("count(//gml:ArcString)", CoreMatchers.equalTo((Object)"1")));
        MatcherAssert.assertThat((Object)doc, (Matcher)this.hasXPath("count(//gml:LineStringSegment)", CoreMatchers.equalTo((Object)"1")));
        MatcherAssert.assertThat((Object)doc, (Matcher)this.hasXPath("//gml:ArcString/@interpolation", CoreMatchers.equalTo((Object)"circularArc3Points")));
        MatcherAssert.assertThat((Object)doc, (Matcher)this.hasXPath("//gml:ArcString/gml:posList", CoreMatchers.equalTo((Object)"0 0 2 0 2 1 2 3 4 3")));
        MatcherAssert.assertThat((Object)doc, (Matcher)this.hasXPath("//gml:LineStringSegment/@interpolation", CoreMatchers.equalTo((Object)"linear")));
        MatcherAssert.assertThat((Object)doc, (Matcher)this.hasXPath("//gml:LineStringSegment/gml:posList", CoreMatchers.equalTo((Object)"4 3 4 5 1 4 0 0")));
        MatcherAssert.assertThat((Object)doc, (Matcher)this.hasXPath("//gml:Curve/@gml:id", CoreMatchers.equalTo((Object)"compound.3")));
    }
}

