/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gml3.bindings;

import org.geotools.api.referencing.crs.CoordinateReferenceSystem;
import org.geotools.gml3.GML;
import org.geotools.gml3.GML3TestSupport;
import org.geotools.gml3.bindings.GML3MockData;
import org.junit.Assert;
import org.junit.Test;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Point;
import org.w3c.dom.Document;

public class PointTypeBindingTest
extends GML3TestSupport {
    @Test
    public void testPos() throws Exception {
        GML3MockData.point(this.document, this.document);
        Point p = (Point)this.parse();
        Assert.assertNotNull((Object)p);
        Assert.assertEquals((Object)new Coordinate(1.0, 2.0), (Object)p.getCoordinate());
        Assert.assertTrue((boolean)(p.getUserData() instanceof CoordinateReferenceSystem));
    }

    @Test
    public void testPos3D() throws Exception {
        GML3MockData.point3D(this.document, this.document);
        Point p = (Point)this.parse();
        Assert.assertNotNull((Object)p);
        Assert.assertTrue((boolean)new Coordinate(1.0, 2.0, 10.0).equals3D(p.getCoordinate()));
        Assert.assertTrue((boolean)(p.getUserData() instanceof CoordinateReferenceSystem));
    }

    @Test
    public void testEncode() throws Exception {
        Point p = GML3MockData.point();
        Document dom = this.encode(p, GML.Point);
        Assert.assertEquals((long)1L, (long)dom.getElementsByTagNameNS("http://www.opengis.net/gml", GML.pos.getLocalPart()).getLength());
        Assert.assertEquals((Object)"urn:x-ogc:def:crs:EPSG:4326", (Object)dom.getDocumentElement().getAttribute("srsName"));
    }

    @Test
    public void testEncode2D() throws Exception {
        Point point = GML3MockData.pointLite2D();
        Document doc = this.encode(point, GML.Point);
        this.checkDimension(doc, GML.Point.getLocalPart(), 2);
        this.checkPosOrdinates(doc, 2);
    }

    @Test
    public void testEncode3D() throws Exception {
        Point point = GML3MockData.pointLite3D();
        Document doc = this.encode(point, GML.Point);
        this.checkDimension(doc, GML.Point.getLocalPart(), 3);
        this.checkPosOrdinates(doc, 3);
    }
}

