/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gml3.bindings;

import org.geotools.gml3.GML;
import org.geotools.gml3.GML3TestSupport;
import org.geotools.gml3.bindings.GML3EncodingUtils;
import org.geotools.gml3.bindings.GML3MockData;
import org.geotools.referencing.CRS;
import org.junit.Assert;
import org.junit.Test;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.LinearRing;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.jts.geom.Polygon;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;

public class MultiPolygonTypeBindingTest
extends GML3TestSupport {
    @Test
    public void test() throws Exception {
        GML3MockData.multiPolygon(this.document, this.document);
        MultiPolygon multiPolygon = (MultiPolygon)this.parse();
        Assert.assertNotNull((Object)multiPolygon);
        Assert.assertEquals((long)2L, (long)multiPolygon.getNumGeometries());
    }

    @Test
    public void test3D() throws Exception {
        GML3MockData.multiPolygon3D(this.document, this.document);
        MultiPolygon multiPolygon = (MultiPolygon)this.parse();
        Assert.assertNotNull((Object)multiPolygon);
        Assert.assertEquals((long)2L, (long)multiPolygon.getNumGeometries());
        Polygon polygon = (Polygon)multiPolygon.getGeometryN(0);
        LinearRing exterior = polygon.getExteriorRing();
        Assert.assertTrue((boolean)new Coordinate(1.0, 2.0, 10.0).equals3D(exterior.getCoordinateN(0)));
        LinearRing interior = polygon.getInteriorRingN(0);
        Assert.assertTrue((boolean)new Coordinate(1.0, 2.0, 10.0).equals3D(interior.getCoordinateN(0)));
    }

    @Test
    public void testEncode() throws Exception {
        MultiPolygon geometry = GML3MockData.multiPolygon();
        GML3EncodingUtils.setID((Geometry)geometry, (String)"geometry");
        Document dom = this.encode(geometry, GML.MultiPolygon);
        Assert.assertEquals((Object)"geometry", (Object)this.getID(dom.getDocumentElement()));
        Assert.assertEquals((long)2L, (long)dom.getElementsByTagNameNS("http://www.opengis.net/gml", "polygonMember").getLength());
        NodeList children = dom.getElementsByTagNameNS("http://www.opengis.net/gml", GML.Polygon.getLocalPart());
        Assert.assertEquals((long)2L, (long)children.getLength());
        Assert.assertEquals((Object)"geometry.1", (Object)this.getID(children.item(0)));
        Assert.assertEquals((Object)"geometry.2", (Object)this.getID(children.item(1)));
    }

    @Test
    public void testEncodePolygon() throws Exception {
        Polygon geometry = GML3MockData.polygon();
        geometry.setUserData((Object)CRS.decode((String)"EPSG:4326"));
        GML3EncodingUtils.setID((Geometry)geometry, (String)"geometry");
        Document dom = this.encode(geometry, GML.MultiPolygon);
        Assert.assertEquals((Object)"urn:x-ogc:def:crs:EPSG:4326", (Object)dom.getElementsByTagNameNS("http://www.opengis.net/gml", "MultiPolygon").item(0).getAttributes().getNamedItem("srsName").getTextContent());
        Assert.assertNull((Object)dom.getElementsByTagNameNS("http://www.opengis.net/gml", "Polygon").item(0).getAttributes().getNamedItem("srsName"));
    }
}

