/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gml3.bindings;

import org.geotools.gml3.GML;
import org.geotools.gml3.GML3TestSupport;
import org.geotools.gml3.bindings.GML3EncodingUtils;
import org.geotools.gml3.bindings.GML3MockData;
import org.junit.Assert;
import org.junit.Test;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.MultiLineString;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;

public class MultiCurveTypeBindingTest
extends GML3TestSupport {
    @Test
    public void testEncode() throws Exception {
        MultiLineString geometry = GML3MockData.multiLineString();
        GML3EncodingUtils.setID((Geometry)geometry, (String)"geometry");
        Document dom = this.encode(geometry, GML.MultiCurve);
        Assert.assertEquals((Object)"geometry", (Object)this.getID(dom.getDocumentElement()));
        Assert.assertEquals((long)2L, (long)dom.getElementsByTagNameNS("http://www.opengis.net/gml", "curveMember").getLength());
        NodeList children = dom.getElementsByTagNameNS("http://www.opengis.net/gml", GML.LineString.getLocalPart());
        Assert.assertEquals((long)2L, (long)children.getLength());
        Assert.assertEquals((Object)"geometry.1", (Object)this.getID(children.item(0)));
        Assert.assertEquals((Object)"geometry.2", (Object)this.getID(children.item(1)));
    }

    @Test
    public void testParseWithCurveMember() throws Exception {
        GML3MockData.multiCurve(this.document, this.document);
        MultiLineString mline = (MultiLineString)this.parse();
        Assert.assertEquals((long)2L, (long)mline.getNumGeometries());
    }

    @Test
    public void testParseWithCurveMembers() throws Exception {
        GML3MockData.multiCurve(this.document, this.document, false);
        MultiLineString mline = (MultiLineString)this.parse();
        Assert.assertEquals((long)2L, (long)mline.getNumGeometries());
    }
}

