/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gml3.bindings;

import org.geotools.gml3.GML;
import org.geotools.gml3.GML3TestSupport;
import org.geotools.gml3.bindings.GML3MockData;
import org.junit.Assert;
import org.junit.Test;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.LineString;
import org.w3c.dom.Document;

public class LineStringTypeBindingTest
extends GML3TestSupport {
    @Test
    public void testPos() throws Exception {
        this.document.appendChild(GML3MockData.lineStringWithPos(this.document, null));
        LineString line = (LineString)this.parse();
        Assert.assertNotNull((Object)line);
        Assert.assertEquals((Object)new Coordinate(1.0, 2.0), (Object)line.getPointN(0).getCoordinate());
        Assert.assertEquals((Object)new Coordinate(3.0, 4.0), (Object)line.getPointN(1).getCoordinate());
    }

    @Test
    public void testPos3D() throws Exception {
        this.document.appendChild(GML3MockData.lineStringWithPos3D(this.document, null));
        LineString line = (LineString)this.parse();
        Assert.assertNotNull((Object)line);
        Assert.assertTrue((boolean)new Coordinate(1.0, 2.0, 10.0).equals3D(line.getPointN(0).getCoordinate()));
        Assert.assertTrue((boolean)new Coordinate(3.0, 4.0, 20.0).equals3D(line.getPointN(1).getCoordinate()));
    }

    @Test
    public void testPosList() throws Exception {
        this.document.appendChild(GML3MockData.lineStringWithPosList(this.document, null));
        LineString line = (LineString)this.parse();
        Assert.assertNotNull((Object)line);
        Assert.assertEquals((Object)new Coordinate(1.0, 2.0), (Object)line.getPointN(0).getCoordinate());
        Assert.assertEquals((Object)new Coordinate(3.0, 4.0), (Object)line.getPointN(1).getCoordinate());
    }

    @Test
    public void testPosList3D() throws Exception {
        this.document.appendChild(GML3MockData.lineStringWithPosList3D(this.document, null));
        LineString line = (LineString)this.parse();
        Assert.assertNotNull((Object)line);
        Assert.assertTrue((boolean)new Coordinate(1.0, 2.0, 10.0).equals3D(line.getPointN(0).getCoordinate()));
        Assert.assertTrue((boolean)new Coordinate(3.0, 4.0, 20.0).equals3D(line.getPointN(1).getCoordinate()));
    }

    @Test
    public void testEncodeLineString() throws Exception {
        LineString line = GML3MockData.lineString();
        Document doc = this.encode(line, GML.LineString);
        int expectedDim = 2;
        this.checkDimension(doc, GML.LineString.getLocalPart(), expectedDim);
        this.checkPosListOrdinates(doc, expectedDim * line.getNumPoints());
    }

    @Test
    public void testEncodeLite2D() throws Exception {
        LineString line = GML3MockData.lineStringLite2D();
        Document doc = this.encode(line, GML.LineString);
        int expectedDim = 2;
        this.checkDimension(doc, GML.LineString.getLocalPart(), expectedDim);
        this.checkPosListOrdinates(doc, expectedDim * line.getNumPoints());
    }

    @Test
    public void testEncodeLite3D() throws Exception {
        LineString line = GML3MockData.lineStringLite3D();
        Document doc = this.encode(line, GML.LineString);
        int expectedDim = 3;
        this.checkDimension(doc, GML.LineString.getLocalPart(), expectedDim);
        this.checkPosListOrdinates(doc, expectedDim * line.getNumPoints());
    }

    @Test
    public void testEncode2DLong() throws Exception {
        LineString line = GML3MockData.lineStringLite2D(10);
        Document doc = this.encode(line, GML.LineString);
        int expectedDim = 2;
        this.checkDimension(doc, GML.LineString.getLocalPart(), expectedDim);
        this.checkPosListOrdinates(doc, expectedDim * line.getNumPoints());
    }
}

