/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gml3.bindings;

import org.geotools.api.geometry.Position;
import org.geotools.geometry.Position1D;
import org.geotools.geometry.Position2D;
import org.geotools.geometry.Position3D;
import org.geotools.geometry.jts.coordinatesequence.CoordinateSequences;
import org.geotools.gml3.GML;
import org.geotools.gml3.GML3TestSupport;
import org.geotools.gml3.bindings.GML3MockData;
import org.junit.Assert;
import org.junit.Test;
import org.locationtech.jts.geom.CoordinateSequence;
import org.locationtech.jts.geom.LineString;
import org.w3c.dom.Document;

public class DirectPositionListTypeBindingTest
extends GML3TestSupport {
    @Test
    public void test1D() throws Exception {
        GML3MockData.element(GML.posList, this.document, this.document);
        this.document.getDocumentElement().setAttribute("srsDimension", "1");
        this.document.getDocumentElement().setAttribute("count", "2");
        this.document.getDocumentElement().appendChild(this.document.createTextNode("1.0 2.0 "));
        Position[] dps = (Position[])this.parse();
        Assert.assertNotNull((Object)dps);
        Assert.assertEquals((long)2L, (long)dps.length);
        Assert.assertTrue((boolean)(dps[0] instanceof Position1D));
        Assert.assertTrue((boolean)(dps[1] instanceof Position1D));
        Assert.assertEquals((double)1.0, (double)dps[0].getOrdinate(0), (double)0.0);
        Assert.assertEquals((double)2.0, (double)dps[1].getOrdinate(0), (double)0.0);
    }

    @Test
    public void test2D() throws Exception {
        GML3MockData.element(GML.posList, this.document, this.document);
        this.document.getDocumentElement().setAttribute("srsDimension", "2");
        this.document.getDocumentElement().setAttribute("count", "1");
        this.document.getDocumentElement().appendChild(this.document.createTextNode("1.0 2.0 "));
        Position[] dps = (Position[])this.parse();
        Assert.assertNotNull((Object)dps);
        Assert.assertEquals((long)1L, (long)dps.length);
        Assert.assertTrue((boolean)(dps[0] instanceof Position2D));
        Assert.assertEquals((double)1.0, (double)dps[0].getOrdinate(0), (double)0.0);
        Assert.assertEquals((double)2.0, (double)dps[0].getOrdinate(1), (double)0.0);
    }

    @Test
    public void test3D() throws Exception {
        GML3MockData.element(GML.posList, this.document, this.document);
        this.document.getDocumentElement().setAttribute("srsDimension", "3");
        this.document.getDocumentElement().appendChild(this.document.createTextNode("1.0 2.0 1.0 3 4 5"));
        Position[] dps = (Position[])this.parse();
        Assert.assertNotNull((Object)dps);
        Assert.assertEquals((long)2L, (long)dps.length);
        Assert.assertTrue((boolean)(dps[0] instanceof Position3D));
        Assert.assertEquals((double)1.0, (double)dps[0].getOrdinate(0), (double)0.0);
        Assert.assertEquals((double)2.0, (double)dps[0].getOrdinate(1), (double)0.0);
        Assert.assertEquals((double)1.0, (double)dps[0].getOrdinate(2), (double)0.0);
        Assert.assertEquals((double)3.0, (double)dps[1].getOrdinate(0), (double)0.0);
        Assert.assertEquals((double)4.0, (double)dps[1].getOrdinate(1), (double)0.0);
        Assert.assertEquals((double)5.0, (double)dps[1].getOrdinate(2), (double)0.0);
    }

    @Test
    public void testEncode2D() throws Exception {
        LineString line = GML3MockData.lineStringLite2D();
        CoordinateSequence seq = line.getCoordinateSequence();
        Document doc = this.encode(seq, GML.posList);
        this.checkPosListOrdinates(doc, CoordinateSequences.coordinateDimension((CoordinateSequence)seq) * line.getNumPoints());
    }

    @Test
    public void testEncode3D() throws Exception {
        LineString line = GML3MockData.lineStringLite3D();
        CoordinateSequence seq = line.getCoordinateSequence();
        Document doc = this.encode(seq, GML.posList);
        this.checkPosListOrdinates(doc, CoordinateSequences.coordinateDimension((CoordinateSequence)seq) * line.getNumPoints());
    }
}

