/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gml3.bindings;

import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.gml3.GML;
import org.geotools.gml3.GML3TestSupport;
import org.geotools.referencing.CRS;
import org.junit.Assert;
import org.junit.Test;
import org.locationtech.jts.geom.Envelope;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class BoundingShapeTypeBindingTest
extends GML3TestSupport {
    @Test
    public void testEncode() throws Exception {
        Envelope e = new Envelope(-180.0, -90.0, 180.0, 90.0);
        Document dom = this.encode(e, GML.boundedBy);
        Assert.assertEquals((Object)"gml:Envelope", (Object)dom.getDocumentElement().getFirstChild().getNodeName());
    }

    @Test
    public void testEncodeWithCRS() throws Exception {
        ReferencedEnvelope e = new ReferencedEnvelope(-180.0, -90.0, 180.0, 90.0, CRS.decode((String)"EPSG:4326"));
        Document dom = this.encode(e, GML.boundedBy);
        Assert.assertEquals((Object)"gml:Envelope", (Object)dom.getDocumentElement().getFirstChild().getNodeName());
        Assert.assertTrue((boolean)((Element)dom.getDocumentElement().getFirstChild()).getAttribute("srsName").endsWith("4326"));
    }

    @Test
    public void testEncodeAsNull() throws Exception {
        Envelope e = new Envelope();
        e.setToNull();
        Document dom = this.encode(e, GML.boundedBy);
        Assert.assertEquals((Object)"gml:Null", (Object)dom.getDocumentElement().getFirstChild().getNodeName());
    }
}

