/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gml3.bindings;

import java.util.Map;
import org.geotools.api.feature.simple.SimpleFeature;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.data.simple.SimpleFeatureIterator;
import org.geotools.gml3.GML;
import org.geotools.gml3.GML3TestSupport;
import org.geotools.gml3.bindings.GML3MockData;
import org.geotools.gml3.bindings.TEST;
import org.geotools.gml3.bindings.TestConfiguration;
import org.geotools.xsd.Configuration;
import org.junit.Assert;
import org.junit.Test;
import org.w3c.dom.Element;

public class AbstractFeatureCollectionTypeBindingTest
extends GML3TestSupport {
    @Override
    protected Map<String, String> getNamespaces() {
        Map<String, String> namespaces = super.getNamespaces();
        namespaces.put("test", TEST.NAMESPACE);
        return namespaces;
    }

    @Override
    protected Configuration createConfiguration() {
        return new TestConfiguration();
    }

    @Test
    public void testFeatureMember() throws Exception {
        Element featureCollection = GML3MockData.element(TEST.TestFeatureCollection, this.document, this.document);
        Element featureMember = GML3MockData.element(GML.featureMember, this.document, featureCollection);
        Element feature = GML3MockData.feature(this.document, featureMember);
        feature.setAttributeNS("http://www.opengis.net/gml", "id", "fid.1");
        featureMember = GML3MockData.element(GML.featureMember, this.document, featureCollection);
        feature = GML3MockData.feature(this.document, featureMember);
        feature.setAttributeNS("http://www.opengis.net/gml", "id", "fid.2");
        SimpleFeatureCollection fc = (SimpleFeatureCollection)this.parse();
        Assert.assertNotNull((Object)fc);
        Assert.assertEquals((long)2L, (long)fc.size());
        try (SimpleFeatureIterator i = fc.features();){
            SimpleFeature f = (SimpleFeature)i.next();
            Assert.assertEquals((Object)"fid.1", (Object)f.getID());
            f = (SimpleFeature)i.next();
            Assert.assertEquals((Object)"fid.2", (Object)f.getID());
        }
    }

    @Test
    public void testFeatureMembers() throws Exception {
        Element featureCollection = GML3MockData.element(TEST.TestFeatureCollection, this.document, this.document);
        Element featureMember = GML3MockData.element(GML.featureMembers, this.document, featureCollection);
        Element feature = GML3MockData.feature(this.document, featureMember);
        feature.setAttributeNS("http://www.opengis.net/gml", "id", "fid.1");
        feature = GML3MockData.feature(this.document, featureMember);
        feature.setAttributeNS("http://www.opengis.net/gml", "id", "fid.2");
        SimpleFeatureCollection fc = (SimpleFeatureCollection)this.parse();
        Assert.assertNotNull((Object)fc);
        Assert.assertEquals((long)2L, (long)fc.size());
        try (SimpleFeatureIterator i = fc.features();){
            SimpleFeature f = (SimpleFeature)i.next();
            Assert.assertEquals((Object)"fid.1", (Object)f.getID());
            f = (SimpleFeature)i.next();
            Assert.assertEquals((Object)"fid.2", (Object)f.getID());
        }
    }
}

