/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gml3;

import java.util.List;
import org.geotools.geometry.jts.CircularArc;
import org.geotools.geometry.jts.CircularRing;
import org.geotools.geometry.jts.CircularString;
import org.geotools.geometry.jts.CompoundCurvedGeometry;
import org.geotools.geometry.jts.CurvePolygon;
import org.geotools.geometry.jts.CurvedGeometries;
import org.geotools.geometry.jts.CurvedGeometryFactory;
import org.geotools.geometry.jts.MultiCurve;
import org.geotools.geometry.jts.MultiSurface;
import org.geotools.gml3.GML3TestSupport;
import org.geotools.gml3.GMLConfiguration;
import org.geotools.xsd.Configuration;
import org.geotools.xsd.Parser;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineString;

public class GML3CurveParsingTest
extends GML3TestSupport {
    protected static final double TOLERANCE = 1.0E-9;
    protected Configuration gml;

    @Before
    public void setUp() throws Exception {
        GMLConfiguration configuration = new GMLConfiguration(true);
        configuration.setGeometryFactory((GeometryFactory)new CurvedGeometryFactory(1.0E-9));
        this.gml = configuration;
    }

    @Test
    public void testSingleArc() throws Exception {
        Parser p = new Parser(this.gml);
        Object arc = p.parse(GML3CurveParsingTest.class.getResourceAsStream("v3_2/singleArc.xml"));
        MatcherAssert.assertThat((Object)arc, (Matcher)CoreMatchers.instanceOf(CircularString.class));
        CircularString cs = (CircularString)arc;
        Assert.assertArrayEquals((double[])new double[]{10.0, 15.0, 15.0, 20.0, 20.0, 15.0}, (double[])cs.getControlPoints(), (double)0.0);
        Assert.assertEquals((double)1.0E-9, (double)cs.getTolerance(), (double)0.0);
    }

    @Test
    public void testArcString() throws Exception {
        Parser p = new Parser(this.gml);
        Object arc = p.parse(GML3CurveParsingTest.class.getResourceAsStream("v3_2/arcString.xml"));
        MatcherAssert.assertThat((Object)arc, (Matcher)CoreMatchers.instanceOf(CircularString.class));
        CircularString cs = (CircularString)arc;
        Assert.assertArrayEquals((double[])new double[]{10.0, 35.0, 15.0, 40.0, 20.0, 35.0, 25.0, 30.0, 30.0, 35.0}, (double[])cs.getControlPoints(), (double)0.0);
        Assert.assertEquals((double)1.0E-9, (double)cs.getTolerance(), (double)0.0);
    }

    @Test
    public void testCompoundOpen() throws Exception {
        Parser p = new Parser(this.gml);
        Object g = p.parse(GML3CurveParsingTest.class.getResourceAsStream("v3_2/compoundOpen.xml"));
        MatcherAssert.assertThat((Object)g, (Matcher)CoreMatchers.instanceOf(CompoundCurvedGeometry.class));
        CompoundCurvedGeometry compound = (CompoundCurvedGeometry)g;
        Assert.assertEquals((double)1.0E-9, (double)compound.getTolerance(), (double)0.0);
        List components = compound.getComponents();
        Assert.assertEquals((long)3L, (long)components.size());
        LineString ls1 = (LineString)components.get(0);
        Assert.assertEquals((long)2L, (long)ls1.getNumPoints());
        Assert.assertEquals((Object)new Coordinate(10.0, 45.0), (Object)ls1.getCoordinateN(0));
        Assert.assertEquals((Object)new Coordinate(20.0, 45.0), (Object)ls1.getCoordinateN(1));
        CircularString cs = (CircularString)components.get(1);
        Assert.assertArrayEquals((double[])new double[]{20.0, 45.0, 23.0, 48.0, 20.0, 51.0}, (double[])cs.getControlPoints(), (double)0.0);
        LineString ls2 = (LineString)components.get(2);
        Assert.assertEquals((long)2L, (long)ls2.getNumPoints());
        Assert.assertEquals((Object)new Coordinate(20.0, 51.0), (Object)ls2.getCoordinateN(0));
        Assert.assertEquals((Object)new Coordinate(10.0, 51.0), (Object)ls2.getCoordinateN(1));
    }

    @Test
    public void testCompoundClosed() throws Exception {
        Parser p = new Parser(this.gml);
        Object g = p.parse(GML3CurveParsingTest.class.getResourceAsStream("v3_2/compoundClosed.xml"));
        MatcherAssert.assertThat((Object)g, (Matcher)CoreMatchers.instanceOf(CompoundCurvedGeometry.class));
        CompoundCurvedGeometry compound = (CompoundCurvedGeometry)g;
        Assert.assertEquals((double)1.0E-9, (double)compound.getTolerance(), (double)0.0);
        List components = compound.getComponents();
        Assert.assertEquals((long)2L, (long)components.size());
        LineString ls = (LineString)components.get(0);
        Assert.assertEquals((long)4L, (long)ls.getNumPoints());
        Assert.assertEquals((Object)new Coordinate(10.0, 78.0), (Object)ls.getCoordinateN(0));
        Assert.assertEquals((Object)new Coordinate(10.0, 75.0), (Object)ls.getCoordinateN(1));
        Assert.assertEquals((Object)new Coordinate(20.0, 75.0), (Object)ls.getCoordinateN(2));
        Assert.assertEquals((Object)new Coordinate(20.0, 78.0), (Object)ls.getCoordinateN(3));
        CircularString cs = (CircularString)components.get(1);
        Assert.assertArrayEquals((double[])new double[]{20.0, 78.0, 15.0, 80.0, 10.0, 78.0}, (double[])cs.getControlPoints(), (double)0.0);
    }

    @Test
    public void testCirclePolygon() throws Exception {
        Parser p = new Parser(this.gml);
        Object g = p.parse(GML3CurveParsingTest.class.getResourceAsStream("v3_2/circlePolygon.xml"));
        MatcherAssert.assertThat((Object)g, (Matcher)CoreMatchers.instanceOf(CurvePolygon.class));
        CurvePolygon cp = (CurvePolygon)g;
        Assert.assertEquals((double)1.0E-9, (double)cp.getTolerance(), (double)0.0);
        Assert.assertEquals((long)0L, (long)cp.getNumInteriorRing());
        Assert.assertTrue((boolean)(cp.getExteriorRing() instanceof CircularRing));
        CircularRing shell = (CircularRing)cp.getExteriorRing();
        Assert.assertTrue((boolean)CurvedGeometries.isCircle((Geometry)shell));
        CircularArc arc = shell.getArcN(0);
        Assert.assertEquals((double)5.0, (double)arc.getRadius(), (double)0.0);
        Assert.assertEquals((Object)new Coordinate(15.0, 150.0), (Object)arc.getCenter());
    }

    @Test
    public void testCompoundPolygon() throws Exception {
        Parser p = new Parser(this.gml);
        Object g = p.parse(GML3CurveParsingTest.class.getResourceAsStream("v3_2/compoundPolygon.xml"));
        MatcherAssert.assertThat((Object)g, (Matcher)CoreMatchers.instanceOf(CurvePolygon.class));
        CurvePolygon cp = (CurvePolygon)g;
        Assert.assertEquals((double)1.0E-9, (double)cp.getTolerance(), (double)0.0);
        Assert.assertEquals((long)0L, (long)cp.getNumInteriorRing());
        Assert.assertTrue((boolean)(cp.getExteriorRing() instanceof CompoundCurvedGeometry));
        CompoundCurvedGeometry compound = (CompoundCurvedGeometry)cp.getExteriorRing();
        List components = compound.getComponents();
        Assert.assertEquals((long)2L, (long)components.size());
        LineString ls = (LineString)components.get(0);
        Assert.assertEquals((long)3L, (long)ls.getNumPoints());
        Assert.assertEquals((Object)new Coordinate(6.0, 10.0), (Object)ls.getCoordinateN(0));
        Assert.assertEquals((Object)new Coordinate(10.0, 1.0), (Object)ls.getCoordinateN(1));
        Assert.assertEquals((Object)new Coordinate(14.0, 10.0), (Object)ls.getCoordinateN(2));
        CircularString cs = (CircularString)components.get(1);
        Assert.assertArrayEquals((double[])new double[]{14.0, 10.0, 10.0, 14.0, 6.0, 10.0}, (double[])cs.getControlPoints(), (double)0.0);
    }

    @Test
    public void testCompoundPolygonWithHole() throws Exception {
        Parser p = new Parser(this.gml);
        Object g = p.parse(GML3CurveParsingTest.class.getResourceAsStream("v3_2/compoundPolygonWithHole.xml"));
        MatcherAssert.assertThat((Object)g, (Matcher)CoreMatchers.instanceOf(CurvePolygon.class));
        CurvePolygon cp = (CurvePolygon)g;
        Assert.assertEquals((double)1.0E-9, (double)cp.getTolerance(), (double)0.0);
        Assert.assertEquals((long)1L, (long)cp.getNumInteriorRing());
        Assert.assertTrue((boolean)(cp.getExteriorRing() instanceof CompoundCurvedGeometry));
        CompoundCurvedGeometry shell = (CompoundCurvedGeometry)cp.getExteriorRing();
        List components = shell.getComponents();
        Assert.assertEquals((long)2L, (long)components.size());
        LineString ls = (LineString)components.get(0);
        Assert.assertEquals((long)7L, (long)ls.getNumPoints());
        Assert.assertEquals((Object)new Coordinate(20.0, 30.0), (Object)ls.getCoordinateN(0));
        Assert.assertEquals((Object)new Coordinate(11.0, 30.0), (Object)ls.getCoordinateN(1));
        Assert.assertEquals((Object)new Coordinate(7.0, 22.0), (Object)ls.getCoordinateN(2));
        Assert.assertEquals((Object)new Coordinate(7.0, 15.0), (Object)ls.getCoordinateN(3));
        Assert.assertEquals((Object)new Coordinate(11.0, 10.0), (Object)ls.getCoordinateN(4));
        Assert.assertEquals((Object)new Coordinate(21.0, 10.0), (Object)ls.getCoordinateN(5));
        Assert.assertEquals((Object)new Coordinate(27.0, 30.0), (Object)ls.getCoordinateN(6));
        CircularString cs = (CircularString)components.get(1);
        Assert.assertArrayEquals((double[])new double[]{27.0, 30.0, 25.0, 27.0, 20.0, 30.0}, (double[])cs.getControlPoints(), (double)0.0);
        Assert.assertTrue((boolean)(cp.getInteriorRingN(0) instanceof CircularRing));
        CircularRing hole = (CircularRing)cp.getInteriorRingN(0);
        Assert.assertTrue((boolean)CurvedGeometries.isCircle((Geometry)hole));
        CircularArc arc = hole.getArcN(0);
        Assert.assertEquals((double)5.0, (double)arc.getRadius(), (double)0.0);
        Assert.assertEquals((Object)new Coordinate(15.0, 17.0), (Object)arc.getCenter());
    }

    @Test
    public void testMultiSurface() throws Exception {
        Parser p = new Parser(this.gml);
        Object g = p.parse(GML3CurveParsingTest.class.getResourceAsStream("v3_2/multiSurface2.xml"));
        MatcherAssert.assertThat((Object)g, (Matcher)CoreMatchers.instanceOf(MultiSurface.class));
        MultiSurface mp = (MultiSurface)g;
        Assert.assertEquals((double)1.0E-9, (double)mp.getTolerance(), (double)0.0);
        Assert.assertEquals((long)2L, (long)mp.getNumGeometries());
        CurvePolygon p1 = (CurvePolygon)mp.getGeometryN(0);
        Assert.assertTrue((boolean)(p1.getExteriorRing() instanceof CompoundCurvedGeometry));
        Assert.assertEquals((long)2L, (long)((CompoundCurvedGeometry)p1.getExteriorRing()).getComponents().size());
        Assert.assertEquals((long)1L, (long)p1.getNumInteriorRing());
        Assert.assertEquals((long)2L, (long)((CompoundCurvedGeometry)p1.getInteriorRingN(0)).getComponents().size());
        CurvePolygon p2 = (CurvePolygon)mp.getGeometryN(1);
        Assert.assertTrue((boolean)(p2.getExteriorRing() instanceof CompoundCurvedGeometry));
        Assert.assertEquals((long)2L, (long)((CompoundCurvedGeometry)p2.getExteriorRing()).getComponents().size());
        Assert.assertEquals((long)0L, (long)p2.getNumInteriorRing());
    }

    @Test
    public void testMultiCurve() throws Exception {
        Parser p = new Parser(this.gml);
        Object g = p.parse(GML3CurveParsingTest.class.getResourceAsStream("v3_2/multiCurve.xml"));
        MatcherAssert.assertThat((Object)g, (Matcher)CoreMatchers.instanceOf(MultiCurve.class));
        MultiCurve mc = (MultiCurve)g;
        Assert.assertEquals((double)1.0E-9, (double)mc.getTolerance(), (double)0.0);
        LineString ls = (LineString)mc.getGeometryN(0);
        Assert.assertEquals((long)2L, (long)ls.getNumPoints());
        Assert.assertEquals((Object)new Coordinate(0.0, 0.0), (Object)ls.getCoordinateN(0));
        Assert.assertEquals((Object)new Coordinate(5.0, 5.0), (Object)ls.getCoordinateN(1));
        CircularString cs = (CircularString)mc.getGeometryN(1);
        Assert.assertArrayEquals((double[])new double[]{4.0, 0.0, 4.0, 4.0, 8.0, 4.0}, (double[])cs.getControlPoints(), (double)0.0);
    }
}

