/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gml3.v3_2;

import java.util.List;
import javax.xml.namespace.QName;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.xsd.XSDElementDeclaration;
import org.eclipse.xsd.XSDSchema;
import org.eclipse.xsd.XSDTypeDefinition;
import org.eclipse.xsd.impl.XSDSchemaImpl;
import org.eclipse.xsd.util.XSDResourceImpl;
import org.geotools.xsd.Schemas;
import org.geotools.xsd.impl.SchemaIndexImpl;
import org.junit.Assert;
import org.junit.Test;

public class EmfXsdLoadTest {
    @Test
    public void test_AbstractGMLType() {
        EmfXsdLoadTest.checkChildElementTypes("gml.xsd", "http://www.opengis.net/gml/3.2", "AbstractGMLType");
    }

    @Test
    public void test_TM_Primitive_PropertyType() {
        EmfXsdLoadTest.checkChildElementTypes("gml.xsd", "http://www.isotc211.org/2005/gts", "TM_Primitive_PropertyType");
    }

    @Test
    public void test_TM_PeriodDuration_PropertyType() {
        EmfXsdLoadTest.checkChildElementTypes("gml.xsd", "http://www.isotc211.org/2005/gts", "TM_PeriodDuration_PropertyType");
    }

    @Test
    public void test_CI_ResponsibleParty_Type() {
        EmfXsdLoadTest.checkChildElementTypes("gml.xsd", "http://www.isotc211.org/2005/gmd", "CI_ResponsibleParty_Type");
    }

    @Test
    public void test_GM_Point_PropertyType() {
        EmfXsdLoadTest.checkChildElementTypes("gml.xsd", "http://www.isotc211.org/2005/gss", "GM_Point_PropertyType");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void checkChildElementTypes(String filename, String namespace, String name) {
        ResourceSet resourceSet = XSDSchemaImpl.createResourceSet();
        XSDResourceImpl resource = (XSDResourceImpl)resourceSet.getResource(URI.createURI((String)EmfXsdLoadTest.class.getResource(filename).toString()), true);
        XSDSchema schema = resource.getSchema();
        Assert.assertNotNull((Object)schema);
        SchemaIndexImpl index = null;
        XSDTypeDefinition type = null;
        try {
            index = new SchemaIndexImpl(new XSDSchema[]{schema});
            type = index.getTypeDefinition(new QName(namespace, name));
        }
        finally {
            if (index != null) {
                index.destroy();
            }
        }
        Assert.assertNotNull((Object)type);
        List children = Schemas.getChildElementDeclarations((XSDTypeDefinition)type);
        boolean foundNull = false;
        for (XSDElementDeclaration child : children) {
            if (child.getTypeDefinition() != null) continue;
            foundNull = true;
        }
        Assert.assertFalse((String)"Unexpected child element declaration with null type", (boolean)foundNull);
    }
}

