/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gml3.simple;

import org.geotools.geometry.jts.WKTReader2;
import org.geotools.gml2.simple.GeometryEncoder;
import org.geotools.gml3.simple.GeometryEncoderTestSupport;
import org.geotools.gml3.simple.PointEncoder;
import org.locationtech.jts.geom.Geometry;
import org.w3c.dom.Document;

public class Point3DTest
extends GeometryEncoderTestSupport {
    public void testEncode3DPoint() throws Exception {
        PointEncoder encoder = new PointEncoder(this.gtEncoder, "gml", "http://www.opengis.net/gml");
        Geometry geometry = new WKTReader2().read("POINT(0 0 50)");
        Document doc = this.encode((GeometryEncoder)encoder, geometry);
        Point3DTest.assertEquals((String)"0 0 50", (String)this.xpath.evaluate("//gml:pos", doc));
    }

    public void testEncodeCoordinatesFormatting() throws Exception {
        PointEncoder encoder = new PointEncoder(this.gtEncoder, "gml", "http://www.opengis.net/gml");
        Geometry geometry = new WKTReader2().read("POINT(21396814.969 0 50)");
        Document doc = this.encode((GeometryEncoder)encoder, geometry, true, null, 4, true, false);
        Point3DTest.assertEquals((String)"21396814.969 0 50", (String)this.xpath.evaluate("//gml:pos", doc));
        doc = this.encode((GeometryEncoder)encoder, geometry, true, null, 2, true, false);
        Point3DTest.assertEquals((String)"21396814.97 0 50", (String)this.xpath.evaluate("//gml:pos", doc));
        doc = this.encode((GeometryEncoder)encoder, geometry, true, null, 4, true, true);
        Point3DTest.assertEquals((String)"21396814.9690 0.0000 50.0000", (String)this.xpath.evaluate("//gml:pos", doc));
        doc = this.encode((GeometryEncoder)encoder, geometry, true, null, 4, false, false);
        Point3DTest.assertEquals((String)"2.1396814969E7 0 50", (String)this.xpath.evaluate("//gml:pos", doc));
    }
}

