/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gml3.simple;

import org.custommonkey.xmlunit.XMLUnit;
import org.custommonkey.xmlunit.XpathEngine;
import org.geotools.geometry.jts.LiteCoordinateSequence;
import org.geotools.gml2.simple.GeometryEncoder;
import org.geotools.gml3.simple.GeometryEncoderTestSupport;
import org.geotools.gml3.simple.LineStringEncoder;
import org.geotools.gml3.simple.PointEncoder;
import org.locationtech.jts.geom.CoordinateSequence;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.Point;
import org.w3c.dom.Document;

public final class LineStringMeasuresTest
extends GeometryEncoderTestSupport {
    public void testEncodeLineMFromLiteCS() throws Exception {
        LiteCoordinateSequence cs = new LiteCoordinateSequence(new double[]{0.0, 1.0, -1.5, 3.0, 4.0, -2.5}, 3, 1);
        LineString geometry = new GeometryFactory().createLineString((CoordinateSequence)cs);
        LineStringEncoder encoder = new LineStringEncoder(this.gtEncoder, "gml", "http://www.opengis.net/gml");
        Document document = this.encode((GeometryEncoder)encoder, (Geometry)geometry, "line");
        XpathEngine xpath = XMLUnit.newXpathEngine();
        LineStringMeasuresTest.assertEquals((String)"0 1 -1.5 3 4 -2.5", (String)xpath.evaluate("//gml:posList", document));
    }

    public void testEncodeLineMFromLiteCSNoMeasuresEncoded() throws Exception {
        LiteCoordinateSequence cs = new LiteCoordinateSequence(new double[]{0.0, 1.0, -1.5, 3.0, 4.0, -2.5}, 3, 1);
        LineString geometry = new GeometryFactory().createLineString((CoordinateSequence)cs);
        LineStringEncoder encoder = new LineStringEncoder(this.gtEncoder, "gml", "http://www.opengis.net/gml");
        Document document = this.encode((GeometryEncoder)encoder, (Geometry)geometry, false, "line");
        XpathEngine xpath = XMLUnit.newXpathEngine();
        LineStringMeasuresTest.assertEquals((String)"0 1 3 4", (String)xpath.evaluate("//gml:posList", document));
    }

    public void testEncodePointMFromLiteCS() throws Exception {
        LiteCoordinateSequence cs = new LiteCoordinateSequence(new double[]{0.0, 1.0, -1.5}, 3, 1);
        Point geometry = new GeometryFactory().createPoint((CoordinateSequence)cs);
        PointEncoder encoder = new PointEncoder(this.gtEncoder, "gml", "http://www.opengis.net/gml");
        Document document = this.encode((GeometryEncoder)encoder, (Geometry)geometry, "line");
        XpathEngine xpath = XMLUnit.newXpathEngine();
        LineStringMeasuresTest.assertEquals((String)"0 1 -1.5", (String)xpath.evaluate("//gml:pos", document));
    }

    public void testEncodePointMFromLiteCSNoMeasuresEncoded() throws Exception {
        LiteCoordinateSequence cs = new LiteCoordinateSequence(new double[]{0.0, 1.0, -1.5}, 3, 1);
        Point geometry = new GeometryFactory().createPoint((CoordinateSequence)cs);
        PointEncoder encoder = new PointEncoder(this.gtEncoder, "gml", "http://www.opengis.net/gml");
        Document document = this.encode((GeometryEncoder)encoder, (Geometry)geometry, false, "line");
        XpathEngine xpath = XMLUnit.newXpathEngine();
        LineStringMeasuresTest.assertEquals((String)"0 1", (String)xpath.evaluate("//gml:pos", document));
    }

    public void testEncodeLineZMFromLiteCS() throws Exception {
        LiteCoordinateSequence cs = new LiteCoordinateSequence(new double[]{0.0, 1.0, 10.0, -1.5, 3.0, 4.0, 15.0, -2.5}, 4, 1);
        LineString geometry = new GeometryFactory().createLineString((CoordinateSequence)cs);
        LineStringEncoder encoder = new LineStringEncoder(this.gtEncoder, "gml", "http://www.opengis.net/gml");
        Document document = this.encode((GeometryEncoder)encoder, (Geometry)geometry, "line");
        XpathEngine xpath = XMLUnit.newXpathEngine();
        LineStringMeasuresTest.assertEquals((String)"0 1 10 -1.5 3 4 15 -2.5", (String)xpath.evaluate("//gml:posList", document));
    }

    public void testEncodeLineZMFromLiteCSNoMeasuresEncoded() throws Exception {
        LiteCoordinateSequence cs = new LiteCoordinateSequence(new double[]{0.0, 1.0, 10.0, -1.5, 3.0, 4.0, 15.0, -2.5}, 4, 1);
        LineString geometry = new GeometryFactory().createLineString((CoordinateSequence)cs);
        LineStringEncoder encoder = new LineStringEncoder(this.gtEncoder, "gml", "http://www.opengis.net/gml");
        Document document = this.encode((GeometryEncoder)encoder, (Geometry)geometry, false, "line");
        XpathEngine xpath = XMLUnit.newXpathEngine();
        LineStringMeasuresTest.assertEquals((String)"0 1 10 3 4 15", (String)xpath.evaluate("//gml:posList", document));
    }

    public void testEncodePointZMFromLiteCS() throws Exception {
        LiteCoordinateSequence cs = new LiteCoordinateSequence(new double[]{0.0, 1.0, 10.0, -1.5}, 4, 1);
        Point geometry = new GeometryFactory().createPoint((CoordinateSequence)cs);
        PointEncoder encoder = new PointEncoder(this.gtEncoder, "gml", "http://www.opengis.net/gml");
        Document document = this.encode((GeometryEncoder)encoder, (Geometry)geometry, "line");
        XpathEngine xpath = XMLUnit.newXpathEngine();
        LineStringMeasuresTest.assertEquals((String)"0 1 10 -1.5", (String)xpath.evaluate("//gml:pos", document));
    }

    public void testEncodePointZMFromLiteCSNoMeasuresEncoded() throws Exception {
        LiteCoordinateSequence cs = new LiteCoordinateSequence(new double[]{0.0, 1.0, 10.0, -1.5}, 4, 1);
        Point geometry = new GeometryFactory().createPoint((CoordinateSequence)cs);
        PointEncoder encoder = new PointEncoder(this.gtEncoder, "gml", "http://www.opengis.net/gml");
        Document document = this.encode((GeometryEncoder)encoder, (Geometry)geometry, false, "line");
        XpathEngine xpath = XMLUnit.newXpathEngine();
        LineStringMeasuresTest.assertEquals((String)"0 1 10", (String)xpath.evaluate("//gml:pos", document));
    }
}

