/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gml3.simple;

import org.geotools.geometry.jts.WKTReader2;
import org.geotools.gml2.simple.GeometryEncoder;
import org.geotools.gml3.simple.GeometryEncoderTestSupport;
import org.geotools.gml3.simple.PolygonEncoder;
import org.locationtech.jts.geom.Geometry;
import org.w3c.dom.Document;

public class CurvePolygonEncoderTest
extends GeometryEncoderTestSupport {
    public void testCircle() throws Exception {
        PolygonEncoder encoder = new PolygonEncoder(this.gtEncoder, "gml", "http://www.opengis.net/gml");
        Geometry geometry = new WKTReader2().read("CURVEPOLYGON(CIRCULARSTRING(-10 0, -8 2, -6 0, -8 -2, -10 0))");
        Document doc = this.encode((GeometryEncoder)encoder, geometry);
        CurvePolygonEncoderTest.assertEquals((int)1, (int)this.xpath.getMatchingNodes("//gml:Polygon", doc).getLength());
        CurvePolygonEncoderTest.assertEquals((int)1, (int)this.xpath.getMatchingNodes("//gml:Polygon/gml:exterior", doc).getLength());
        CurvePolygonEncoderTest.assertEquals((int)0, (int)this.xpath.getMatchingNodes("//gml:Polygon/gml:interior", doc).getLength());
        String ext1 = "//gml:Polygon/gml:exterior/gml:Ring/gml:curveMember[1]";
        CurvePolygonEncoderTest.assertEquals((String)"circularArc3Points", (String)this.xpath.evaluate(ext1 + "/gml:Curve/gml:segments/gml:ArcString/@interpolation", doc));
        CurvePolygonEncoderTest.assertEquals((String)"-10 0 -8 2 -6 0 -8 -2 -10 0", (String)this.xpath.evaluate(ext1 + "/gml:Curve/gml:segments/gml:ArcString/gml:posList", doc));
    }

    public void testDonut() throws Exception {
        PolygonEncoder encoder = new PolygonEncoder(this.gtEncoder, "gml", "http://www.opengis.net/gml");
        Geometry geometry = new WKTReader2().read("CURVEPOLYGON(CIRCULARSTRING(-7 -8, -5 -6, -3 -8, -5 -10, -7 -8),CIRCULARSTRING(-6 -8, -5 -7, -4 -8, -5 -9, -6 -8))");
        Document doc = this.encode((GeometryEncoder)encoder, geometry);
        CurvePolygonEncoderTest.assertEquals((int)1, (int)this.xpath.getMatchingNodes("//gml:Polygon", doc).getLength());
        CurvePolygonEncoderTest.assertEquals((int)1, (int)this.xpath.getMatchingNodes("//gml:Polygon/gml:exterior", doc).getLength());
        CurvePolygonEncoderTest.assertEquals((int)1, (int)this.xpath.getMatchingNodes("//gml:Polygon/gml:interior", doc).getLength());
        String ext1 = "//gml:Polygon/gml:exterior/gml:Ring/gml:curveMember[1]";
        CurvePolygonEncoderTest.assertEquals((String)"circularArc3Points", (String)this.xpath.evaluate(ext1 + "/gml:Curve/gml:segments/gml:ArcString/@interpolation", doc));
        CurvePolygonEncoderTest.assertEquals((String)"-7 -8 -5 -6 -3 -8 -5 -10 -7 -8", (String)this.xpath.evaluate(ext1 + "/gml:Curve/gml:segments/gml:ArcString/gml:posList", doc));
        String int1 = "//gml:Polygon/gml:interior/gml:Ring/gml:curveMember[1]";
        CurvePolygonEncoderTest.assertEquals((String)"circularArc3Points", (String)this.xpath.evaluate(int1 + "/gml:Curve/gml:segments/gml:ArcString/@interpolation", doc));
        CurvePolygonEncoderTest.assertEquals((String)"-6 -8 -5 -7 -4 -8 -5 -9 -6 -8", (String)this.xpath.evaluate(int1 + "/gml:Curve/gml:segments/gml:ArcString/gml:posList", doc));
    }

    public void testComplex() throws Exception {
        PolygonEncoder encoder = new PolygonEncoder(this.gtEncoder, "gml", "http://www.opengis.net/gml");
        Geometry geometry = new WKTReader2().read("CURVEPOLYGON(COMPOUNDCURVE(CIRCULARSTRING(0 0, 2 0, 2 1, 2 3, 4 3),(4 3, 4 5, 1 4, 0 0)), CIRCULARSTRING(1.7 1, 1.4 0.4, 1.6 0.4, 1.6 0.5, 1.7 1) )");
        Document doc = this.encode((GeometryEncoder)encoder, geometry);
        CurvePolygonEncoderTest.assertEquals((int)1, (int)this.xpath.getMatchingNodes("//gml:Polygon", doc).getLength());
        CurvePolygonEncoderTest.assertEquals((int)1, (int)this.xpath.getMatchingNodes("//gml:Polygon/gml:exterior", doc).getLength());
        CurvePolygonEncoderTest.assertEquals((int)1, (int)this.xpath.getMatchingNodes("//gml:Polygon/gml:interior", doc).getLength());
        String ext1 = "//gml:Polygon/gml:exterior/gml:Ring/gml:curveMember[1]";
        CurvePolygonEncoderTest.assertEquals((String)"circularArc3Points", (String)this.xpath.evaluate(ext1 + "/gml:Curve/gml:segments/gml:ArcString/@interpolation", doc));
        CurvePolygonEncoderTest.assertEquals((String)"0 0 2 0 2 1 2 3 4 3", (String)this.xpath.evaluate(ext1 + "/gml:Curve/gml:segments/gml:ArcString/gml:posList", doc));
        String ext2 = "//gml:Polygon/gml:exterior/gml:Ring/gml:curveMember[2]";
        CurvePolygonEncoderTest.assertEquals((String)"4 3 4 5 1 4 0 0", (String)this.xpath.evaluate(ext2 + "/gml:LineString/gml:posList", doc));
        String int1 = "//gml:Polygon/gml:interior/gml:Ring/gml:curveMember[1]";
        CurvePolygonEncoderTest.assertEquals((String)"circularArc3Points", (String)this.xpath.evaluate(int1 + "/gml:Curve/gml:segments/gml:ArcString/@interpolation", doc));
        CurvePolygonEncoderTest.assertEquals((String)"1.7 1 1.4 0.4 1.6 0.4 1.6 0.5 1.7 1", (String)this.xpath.evaluate(int1 + "/gml:Curve/gml:segments/gml:ArcString/gml:posList", doc));
    }
}

