/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gml3.bindings;

import org.geotools.gml3.GML;
import org.geotools.gml3.GML3TestSupport;
import org.geotools.gml3.bindings.GML3EncodingUtils;
import org.geotools.gml3.bindings.GML3MockData;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.MultiPolygon;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;

public class MultiSurfaceTypeBindingTest
extends GML3TestSupport {
    public void testEncode() throws Exception {
        MultiPolygon geometry = GML3MockData.multiPolygon();
        GML3EncodingUtils.setID((Geometry)geometry, (String)"geometry");
        Document dom = this.encode(geometry, GML.MultiSurface);
        MultiSurfaceTypeBindingTest.assertEquals((String)"geometry", (String)this.getID(dom.getDocumentElement()));
        MultiSurfaceTypeBindingTest.assertEquals((int)2, (int)dom.getElementsByTagNameNS("http://www.opengis.net/gml", "surfaceMember").getLength());
        NodeList children = dom.getElementsByTagNameNS("http://www.opengis.net/gml", GML.Polygon.getLocalPart());
        MultiSurfaceTypeBindingTest.assertEquals((int)2, (int)children.getLength());
        MultiSurfaceTypeBindingTest.assertEquals((String)"geometry.1", (String)this.getID(children.item(0)));
        MultiSurfaceTypeBindingTest.assertEquals((String)"geometry.2", (String)this.getID(children.item(1)));
    }

    public void testParseWithSurfaceMember() throws Exception {
        GML3MockData.multiSurface(this.document, this.document);
        MultiPolygon mpoly = (MultiPolygon)this.parse();
        MultiSurfaceTypeBindingTest.assertEquals((int)2, (int)mpoly.getNumGeometries());
    }

    public void testParseWithSurfaceMembers() throws Exception {
        GML3MockData.multiSurface(this.document, this.document, false);
        MultiPolygon mpoly = (MultiPolygon)this.parse();
        MultiSurfaceTypeBindingTest.assertEquals((int)2, (int)mpoly.getNumGeometries());
    }
}

