/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gml3.bindings;

import org.geotools.gml3.ComplexAttributeTestSupport;
import org.geotools.gml3.GML;
import org.geotools.gml3.bindings.GML3MockData;
import org.geotools.measure.Measure;
import org.opengis.feature.ComplexAttribute;
import org.w3c.dom.Document;

public class MeasureTypeBindingTest
extends ComplexAttributeTestSupport {
    public void testParser() throws Exception {
        GML3MockData.element(GML.measure, this.document, this.document);
        this.document.getDocumentElement().setAttribute("uom", "http://someuri");
        this.document.getDocumentElement().appendChild(this.document.createTextNode("1234"));
        Measure measure = (Measure)this.parse();
        MeasureTypeBindingTest.assertNotNull((Object)measure);
        MeasureTypeBindingTest.assertEquals((double)1234.0, (double)measure.doubleValue(), (double)0.1);
        MeasureTypeBindingTest.assertEquals((String)"http://someuri", (String)measure.getUnit().getSymbol());
    }

    public void testEncode() throws Exception {
        ComplexAttribute myCode = this.gmlMeasureType(GML.measure, "12", "m");
        Document dom = this.encode(myCode, GML.measure);
        MeasureTypeBindingTest.assertEquals((String)"gml:measure", (String)dom.getDocumentElement().getNodeName());
        MeasureTypeBindingTest.assertEquals((String)"12", (String)dom.getDocumentElement().getFirstChild().getNodeValue());
        MeasureTypeBindingTest.assertNotNull((Object)dom.getDocumentElement().getAttribute("uom"));
        MeasureTypeBindingTest.assertEquals((String)"m", (String)dom.getDocumentElement().getAttribute("uom"));
    }
}

