/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gml3.bindings;

import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.xsd.XSDFeature;
import org.eclipse.xsd.XSDNamedComponent;
import org.eclipse.xsd.XSDTypeDefinition;
import org.geotools.data.DataUtilities;
import org.geotools.gml2.bindings.GMLEncodingUtils;
import org.geotools.gml3.GML;
import org.geotools.gml3.GMLConfiguration;
import org.geotools.xsd.Configuration;
import org.geotools.xsd.SchemaIndex;
import org.geotools.xsd.Schemas;
import org.geotools.xsd.XSD;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;
import org.opengis.feature.simple.SimpleFeatureType;

public class GML3EncodingUtilsTest {
    @Test
    public void testGeometriesGML3FeatureEncoding() throws Exception {
        GMLConfiguration configuration = new GMLConfiguration();
        SchemaIndex index = Schemas.findSchemas((Configuration)configuration);
        SimpleFeatureType featureType = DataUtilities.createType((String)"feature", (String)"geometry1:LineString,geometry2:MultiLineString,geometry3:Polygon,geometry4:MultiPolygon,geometry5:Point,geometry6:MultiPoint");
        GMLEncodingUtils encoder = new GMLEncodingUtils((XSD)GML.getInstance());
        XSDTypeDefinition type = encoder.createXmlTypeFromFeatureType(featureType, index, Collections.emptySet());
        List elements = Schemas.getChildElementDeclarations((XSDTypeDefinition)type, (boolean)false);
        Assert.assertThat((Object)elements, (Matcher)CoreMatchers.notNullValue());
        Assert.assertThat((Object)elements.size(), (Matcher)CoreMatchers.is((Object)6));
        List typesNames = elements.stream().map(XSDFeature::getType).filter(elementType -> elementType != null).map(XSDNamedComponent::getName).collect(Collectors.toList());
        Assert.assertThat((Object)typesNames.size(), (Matcher)CoreMatchers.is((Object)6));
        Assert.assertThat(typesNames, (Matcher)CoreMatchers.hasItems((Object[])new String[]{"LineStringPropertyType", "MultiLineStringPropertyType", "PolygonPropertyType", "MultiPolygonPropertyType", "PointPropertyType", "MultiPointPropertyType"}));
    }
}

