/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gml3.bindings;

import org.geotools.gml3.GML3TestSupport;
import org.geotools.gml3.bindings.GML3MockData;
import org.geotools.gml3.bindings.TEST;
import org.geotools.gml3.bindings.TestConfiguration;
import org.geotools.xsd.Configuration;
import org.locationtech.jts.geom.Point;
import org.opengis.feature.simple.SimpleFeature;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class AbstractFeatureTypeBindingTest
extends GML3TestSupport {
    @Override
    protected Configuration createConfiguration() {
        return new TestConfiguration();
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.registerNamespaceMapping("test", TEST.NAMESPACE);
    }

    public void testWithoutGmlProperties() throws Exception {
        Element feature = GML3MockData.feature(this.document, this.document);
        feature.setAttributeNS("http://www.opengis.net/gml", "id", "fid.1");
        SimpleFeature f = (SimpleFeature)this.parse();
        AbstractFeatureTypeBindingTest.assertNotNull((Object)feature);
        AbstractFeatureTypeBindingTest.assertEquals((String)"fid.1", (String)f.getID());
        Point p = (Point)f.getDefaultGeometry();
        AbstractFeatureTypeBindingTest.assertNotNull((Object)p);
        AbstractFeatureTypeBindingTest.assertEquals((double)1.0, (double)p.getX(), (double)0.0);
        AbstractFeatureTypeBindingTest.assertEquals((double)2.0, (double)p.getY(), (double)0.0);
        Integer i = (Integer)f.getAttribute("count");
        AbstractFeatureTypeBindingTest.assertNotNull((Object)i);
        AbstractFeatureTypeBindingTest.assertEquals((int)1, (int)i);
    }

    public void testEncode() throws Exception {
        Document dom = this.encode(GML3MockData.feature(), TEST.TestFeature);
        AbstractFeatureTypeBindingTest.assertEquals((int)1, (int)dom.getElementsByTagName("gml:boundedBy").getLength());
        AbstractFeatureTypeBindingTest.assertEquals((int)1, (int)dom.getElementsByTagName("test:geom").getLength());
        AbstractFeatureTypeBindingTest.assertEquals((int)1, (int)dom.getElementsByTagName("test:count").getLength());
        AbstractFeatureTypeBindingTest.assertEquals((int)1, (int)dom.getElementsByTagName("test:date").getLength());
    }
}

