/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gml3;

import java.util.List;
import org.geotools.geometry.jts.CircularArc;
import org.geotools.geometry.jts.CircularRing;
import org.geotools.geometry.jts.CircularString;
import org.geotools.geometry.jts.CompoundCurvedGeometry;
import org.geotools.geometry.jts.CurvePolygon;
import org.geotools.geometry.jts.CurvedGeometries;
import org.geotools.geometry.jts.CurvedGeometryFactory;
import org.geotools.geometry.jts.MultiCurve;
import org.geotools.geometry.jts.MultiSurface;
import org.geotools.gml3.GML3TestSupport;
import org.geotools.gml3.GMLConfiguration;
import org.geotools.xsd.Configuration;
import org.geotools.xsd.Parser;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineString;

public class GML3CurveParsingTest
extends GML3TestSupport {
    protected static final double TOLERANCE = 1.0E-9;
    protected Configuration gml;

    @Override
    protected void setUp() throws Exception {
        GMLConfiguration configuration = new GMLConfiguration(true);
        configuration.setGeometryFactory((GeometryFactory)new CurvedGeometryFactory(1.0E-9));
        this.gml = configuration;
    }

    public void testSingleArc() throws Exception {
        Parser p = new Parser(this.gml);
        Object arc = p.parse(GML3CurveParsingTest.class.getResourceAsStream("v3_2/singleArc.xml"));
        Assert.assertThat((Object)arc, (Matcher)CoreMatchers.instanceOf(CircularString.class));
        CircularString cs = (CircularString)arc;
        Assert.assertArrayEquals((double[])new double[]{10.0, 15.0, 15.0, 20.0, 20.0, 15.0}, (double[])cs.getControlPoints(), (double)0.0);
        GML3CurveParsingTest.assertEquals((Object)1.0E-9, (Object)cs.getTolerance());
    }

    public void testArcString() throws Exception {
        Parser p = new Parser(this.gml);
        Object arc = p.parse(GML3CurveParsingTest.class.getResourceAsStream("v3_2/arcString.xml"));
        Assert.assertThat((Object)arc, (Matcher)CoreMatchers.instanceOf(CircularString.class));
        CircularString cs = (CircularString)arc;
        Assert.assertArrayEquals((double[])new double[]{10.0, 35.0, 15.0, 40.0, 20.0, 35.0, 25.0, 30.0, 30.0, 35.0}, (double[])cs.getControlPoints(), (double)0.0);
        GML3CurveParsingTest.assertEquals((Object)1.0E-9, (Object)cs.getTolerance());
    }

    public void testCompoundOpen() throws Exception {
        Parser p = new Parser(this.gml);
        Object g = p.parse(GML3CurveParsingTest.class.getResourceAsStream("v3_2/compoundOpen.xml"));
        Assert.assertThat((Object)g, (Matcher)CoreMatchers.instanceOf(CompoundCurvedGeometry.class));
        CompoundCurvedGeometry compound = (CompoundCurvedGeometry)g;
        GML3CurveParsingTest.assertEquals((Object)1.0E-9, (Object)compound.getTolerance());
        List components = compound.getComponents();
        GML3CurveParsingTest.assertEquals((int)3, (int)components.size());
        LineString ls1 = (LineString)components.get(0);
        GML3CurveParsingTest.assertEquals((int)2, (int)ls1.getNumPoints());
        GML3CurveParsingTest.assertEquals((Object)new Coordinate(10.0, 45.0), (Object)ls1.getCoordinateN(0));
        GML3CurveParsingTest.assertEquals((Object)new Coordinate(20.0, 45.0), (Object)ls1.getCoordinateN(1));
        CircularString cs = (CircularString)components.get(1);
        Assert.assertArrayEquals((double[])new double[]{20.0, 45.0, 23.0, 48.0, 20.0, 51.0}, (double[])cs.getControlPoints(), (double)0.0);
        LineString ls2 = (LineString)components.get(2);
        GML3CurveParsingTest.assertEquals((int)2, (int)ls2.getNumPoints());
        GML3CurveParsingTest.assertEquals((Object)new Coordinate(20.0, 51.0), (Object)ls2.getCoordinateN(0));
        GML3CurveParsingTest.assertEquals((Object)new Coordinate(10.0, 51.0), (Object)ls2.getCoordinateN(1));
    }

    public void testCompoundClosed() throws Exception {
        Parser p = new Parser(this.gml);
        Object g = p.parse(GML3CurveParsingTest.class.getResourceAsStream("v3_2/compoundClosed.xml"));
        Assert.assertThat((Object)g, (Matcher)CoreMatchers.instanceOf(CompoundCurvedGeometry.class));
        CompoundCurvedGeometry compound = (CompoundCurvedGeometry)g;
        GML3CurveParsingTest.assertEquals((Object)1.0E-9, (Object)compound.getTolerance());
        List components = compound.getComponents();
        GML3CurveParsingTest.assertEquals((int)2, (int)components.size());
        LineString ls = (LineString)components.get(0);
        GML3CurveParsingTest.assertEquals((int)4, (int)ls.getNumPoints());
        GML3CurveParsingTest.assertEquals((Object)new Coordinate(10.0, 78.0), (Object)ls.getCoordinateN(0));
        GML3CurveParsingTest.assertEquals((Object)new Coordinate(10.0, 75.0), (Object)ls.getCoordinateN(1));
        GML3CurveParsingTest.assertEquals((Object)new Coordinate(20.0, 75.0), (Object)ls.getCoordinateN(2));
        GML3CurveParsingTest.assertEquals((Object)new Coordinate(20.0, 78.0), (Object)ls.getCoordinateN(3));
        CircularString cs = (CircularString)components.get(1);
        Assert.assertArrayEquals((double[])new double[]{20.0, 78.0, 15.0, 80.0, 10.0, 78.0}, (double[])cs.getControlPoints(), (double)0.0);
    }

    public void testCirclePolygon() throws Exception {
        Parser p = new Parser(this.gml);
        Object g = p.parse(GML3CurveParsingTest.class.getResourceAsStream("v3_2/circlePolygon.xml"));
        Assert.assertThat((Object)g, (Matcher)CoreMatchers.instanceOf(CurvePolygon.class));
        CurvePolygon cp = (CurvePolygon)g;
        GML3CurveParsingTest.assertEquals((Object)1.0E-9, (Object)cp.getTolerance());
        GML3CurveParsingTest.assertEquals((int)0, (int)cp.getNumInteriorRing());
        GML3CurveParsingTest.assertTrue((boolean)(cp.getExteriorRing() instanceof CircularRing));
        CircularRing shell = (CircularRing)cp.getExteriorRing();
        GML3CurveParsingTest.assertTrue((boolean)CurvedGeometries.isCircle((Geometry)shell));
        CircularArc arc = shell.getArcN(0);
        GML3CurveParsingTest.assertEquals((double)5.0, (double)arc.getRadius(), (double)0.0);
        GML3CurveParsingTest.assertEquals((Object)new Coordinate(15.0, 150.0), (Object)arc.getCenter());
    }

    public void testCompoundPolygon() throws Exception {
        Parser p = new Parser(this.gml);
        Object g = p.parse(GML3CurveParsingTest.class.getResourceAsStream("v3_2/compoundPolygon.xml"));
        Assert.assertThat((Object)g, (Matcher)CoreMatchers.instanceOf(CurvePolygon.class));
        CurvePolygon cp = (CurvePolygon)g;
        GML3CurveParsingTest.assertEquals((Object)1.0E-9, (Object)cp.getTolerance());
        GML3CurveParsingTest.assertEquals((int)0, (int)cp.getNumInteriorRing());
        GML3CurveParsingTest.assertTrue((boolean)(cp.getExteriorRing() instanceof CompoundCurvedGeometry));
        CompoundCurvedGeometry compound = (CompoundCurvedGeometry)cp.getExteriorRing();
        List components = compound.getComponents();
        GML3CurveParsingTest.assertEquals((int)2, (int)components.size());
        LineString ls = (LineString)components.get(0);
        GML3CurveParsingTest.assertEquals((int)3, (int)ls.getNumPoints());
        GML3CurveParsingTest.assertEquals((Object)new Coordinate(6.0, 10.0), (Object)ls.getCoordinateN(0));
        GML3CurveParsingTest.assertEquals((Object)new Coordinate(10.0, 1.0), (Object)ls.getCoordinateN(1));
        GML3CurveParsingTest.assertEquals((Object)new Coordinate(14.0, 10.0), (Object)ls.getCoordinateN(2));
        CircularString cs = (CircularString)components.get(1);
        Assert.assertArrayEquals((double[])new double[]{14.0, 10.0, 10.0, 14.0, 6.0, 10.0}, (double[])cs.getControlPoints(), (double)0.0);
    }

    public void testCompoundPolygonWithHole() throws Exception {
        Parser p = new Parser(this.gml);
        Object g = p.parse(GML3CurveParsingTest.class.getResourceAsStream("v3_2/compoundPolygonWithHole.xml"));
        Assert.assertThat((Object)g, (Matcher)CoreMatchers.instanceOf(CurvePolygon.class));
        CurvePolygon cp = (CurvePolygon)g;
        GML3CurveParsingTest.assertEquals((Object)1.0E-9, (Object)cp.getTolerance());
        GML3CurveParsingTest.assertEquals((int)1, (int)cp.getNumInteriorRing());
        GML3CurveParsingTest.assertTrue((boolean)(cp.getExteriorRing() instanceof CompoundCurvedGeometry));
        CompoundCurvedGeometry shell = (CompoundCurvedGeometry)cp.getExteriorRing();
        List components = shell.getComponents();
        GML3CurveParsingTest.assertEquals((int)2, (int)components.size());
        LineString ls = (LineString)components.get(0);
        GML3CurveParsingTest.assertEquals((int)7, (int)ls.getNumPoints());
        GML3CurveParsingTest.assertEquals((Object)new Coordinate(20.0, 30.0), (Object)ls.getCoordinateN(0));
        GML3CurveParsingTest.assertEquals((Object)new Coordinate(11.0, 30.0), (Object)ls.getCoordinateN(1));
        GML3CurveParsingTest.assertEquals((Object)new Coordinate(7.0, 22.0), (Object)ls.getCoordinateN(2));
        GML3CurveParsingTest.assertEquals((Object)new Coordinate(7.0, 15.0), (Object)ls.getCoordinateN(3));
        GML3CurveParsingTest.assertEquals((Object)new Coordinate(11.0, 10.0), (Object)ls.getCoordinateN(4));
        GML3CurveParsingTest.assertEquals((Object)new Coordinate(21.0, 10.0), (Object)ls.getCoordinateN(5));
        GML3CurveParsingTest.assertEquals((Object)new Coordinate(27.0, 30.0), (Object)ls.getCoordinateN(6));
        CircularString cs = (CircularString)components.get(1);
        Assert.assertArrayEquals((double[])new double[]{27.0, 30.0, 25.0, 27.0, 20.0, 30.0}, (double[])cs.getControlPoints(), (double)0.0);
        GML3CurveParsingTest.assertTrue((boolean)(cp.getInteriorRingN(0) instanceof CircularRing));
        CircularRing hole = (CircularRing)cp.getInteriorRingN(0);
        GML3CurveParsingTest.assertTrue((boolean)CurvedGeometries.isCircle((Geometry)hole));
        CircularArc arc = hole.getArcN(0);
        GML3CurveParsingTest.assertEquals((double)5.0, (double)arc.getRadius(), (double)0.0);
        GML3CurveParsingTest.assertEquals((Object)new Coordinate(15.0, 17.0), (Object)arc.getCenter());
    }

    public void testMultiSurface() throws Exception {
        Parser p = new Parser(this.gml);
        Object g = p.parse(GML3CurveParsingTest.class.getResourceAsStream("v3_2/multiSurface2.xml"));
        Assert.assertThat((Object)g, (Matcher)CoreMatchers.instanceOf(MultiSurface.class));
        MultiSurface mp = (MultiSurface)g;
        GML3CurveParsingTest.assertEquals((Object)1.0E-9, (Object)mp.getTolerance());
        GML3CurveParsingTest.assertEquals((int)2, (int)mp.getNumGeometries());
        CurvePolygon p1 = (CurvePolygon)mp.getGeometryN(0);
        GML3CurveParsingTest.assertTrue((boolean)(p1.getExteriorRing() instanceof CompoundCurvedGeometry));
        GML3CurveParsingTest.assertEquals((int)2, (int)((CompoundCurvedGeometry)p1.getExteriorRing()).getComponents().size());
        GML3CurveParsingTest.assertEquals((int)1, (int)p1.getNumInteriorRing());
        GML3CurveParsingTest.assertEquals((int)2, (int)((CompoundCurvedGeometry)p1.getInteriorRingN(0)).getComponents().size());
        CurvePolygon p2 = (CurvePolygon)mp.getGeometryN(1);
        GML3CurveParsingTest.assertTrue((boolean)(p2.getExteriorRing() instanceof CompoundCurvedGeometry));
        GML3CurveParsingTest.assertEquals((int)2, (int)((CompoundCurvedGeometry)p2.getExteriorRing()).getComponents().size());
        GML3CurveParsingTest.assertEquals((int)0, (int)p2.getNumInteriorRing());
    }

    public void testMultiCurve() throws Exception {
        Parser p = new Parser(this.gml);
        Object g = p.parse(GML3CurveParsingTest.class.getResourceAsStream("v3_2/multiCurve.xml"));
        Assert.assertThat((Object)g, (Matcher)CoreMatchers.instanceOf(MultiCurve.class));
        MultiCurve mc = (MultiCurve)g;
        GML3CurveParsingTest.assertEquals((Object)1.0E-9, (Object)mc.getTolerance());
        LineString ls = (LineString)mc.getGeometryN(0);
        GML3CurveParsingTest.assertEquals((int)2, (int)ls.getNumPoints());
        GML3CurveParsingTest.assertEquals((Object)new Coordinate(0.0, 0.0), (Object)ls.getCoordinateN(0));
        GML3CurveParsingTest.assertEquals((Object)new Coordinate(5.0, 5.0), (Object)ls.getCoordinateN(1));
        CircularString cs = (CircularString)mc.getGeometryN(1);
        Assert.assertArrayEquals((double[])new double[]{4.0, 0.0, 4.0, 4.0, 8.0, 4.0}, (double[])cs.getControlPoints(), (double)0.0);
    }
}

