/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gml3.simple;

import org.geotools.geometry.jts.WKTReader2;
import org.geotools.gml3.simple.GeometryEncoderTestSupport;
import org.geotools.gml3.simple.PointEncoder;
import org.junit.Assert;
import org.junit.Test;
import org.locationtech.jts.geom.Point;
import org.w3c.dom.Document;

public class Point3DTest
extends GeometryEncoderTestSupport {
    @Test
    public void testEncode3DPoint() throws Exception {
        PointEncoder encoder = new PointEncoder(this.gtEncoder, "gml", "http://www.opengis.net/gml");
        Point geometry = (Point)new WKTReader2().read("POINT(0 0 50)");
        Document doc = this.encode(encoder, geometry);
        Assert.assertEquals((Object)"0 0 50", (Object)this.xpath.evaluate("//gml:pos", doc));
    }

    @Test
    public void testEncodeCoordinatesFormatting() throws Exception {
        PointEncoder encoder = new PointEncoder(this.gtEncoder, "gml", "http://www.opengis.net/gml");
        Point geometry = (Point)new WKTReader2().read("POINT(21396814.969 0 50)");
        Document doc = this.encode(encoder, geometry, true, (String)null, 4, true, false);
        Assert.assertEquals((Object)"21396814.969 0 50", (Object)this.xpath.evaluate("//gml:pos", doc));
        doc = this.encode(encoder, geometry, true, (String)null, 2, true, false);
        Assert.assertEquals((Object)"21396814.97 0 50", (Object)this.xpath.evaluate("//gml:pos", doc));
        doc = this.encode(encoder, geometry, true, (String)null, 4, true, true);
        Assert.assertEquals((Object)"21396814.9690 0.0000 50.0000", (Object)this.xpath.evaluate("//gml:pos", doc));
        doc = this.encode(encoder, geometry, true, (String)null, 4, false, false);
        Assert.assertEquals((Object)"2.1396814969E7 0 50", (Object)this.xpath.evaluate("//gml:pos", doc));
    }
}

