/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gml3.simple;

import org.geotools.geometry.jts.WKTReader2;
import org.geotools.gml3.simple.GeometryEncoderTestSupport;
import org.geotools.gml3.simple.MultiLineStringEncoder;
import org.junit.Assert;
import org.junit.Test;
import org.locationtech.jts.geom.Geometry;
import org.w3c.dom.Document;

public class MultiCurveEncoderTest
extends GeometryEncoderTestSupport {
    @Test
    public void testEncodeMultiCompound() throws Exception {
        MultiLineStringEncoder encoder = new MultiLineStringEncoder(this.gtEncoder, "gml", "http://www.opengis.net/gml", true);
        Geometry geometry = new WKTReader2().read("MULTICURVE((100 100, 120 120), COMPOUNDCURVE(CIRCULARSTRING(0 0, 2 0, 2 1, 2 3, 4 3),(4 3, 4 5, 1 4, 0 0)))");
        Document doc = this.encode(encoder, geometry);
        Assert.assertEquals((long)1L, (long)this.xpath.getMatchingNodes("//gml:MultiCurve", doc).getLength());
        Assert.assertEquals((long)2L, (long)this.xpath.getMatchingNodes("//gml:MultiCurve/gml:curveMember", doc).getLength());
        Assert.assertEquals((Object)"100 100 120 120", (Object)this.xpath.evaluate("//gml:MultiCurve/gml:curveMember[1]/gml:LineString/gml:posList", doc));
        Assert.assertEquals((long)2L, (long)this.xpath.getMatchingNodes("//gml:MultiCurve/gml:curveMember[2]/gml:Curve/gml:segments/*", doc).getLength());
        Assert.assertEquals((Object)"circularArc3Points", (Object)this.xpath.evaluate("/gml:MultiCurve/gml:curveMember[2]/gml:Curve/gml:segments/gml:ArcString/@interpolation", doc));
        Assert.assertEquals((Object)"0 0 2 0 2 1 2 3 4 3", (Object)this.xpath.evaluate("/gml:MultiCurve/gml:curveMember[2]/gml:Curve/gml:segments/gml:ArcString/gml:posList", doc));
        Assert.assertEquals((Object)"linear", (Object)this.xpath.evaluate("/gml:MultiCurve/gml:curveMember[2]/gml:Curve/gml:segments/gml:LineStringSegment/@interpolation", doc));
        Assert.assertEquals((Object)"4 3 4 5 1 4 0 0", (Object)this.xpath.evaluate("/gml:MultiCurve/gml:curveMember[2]/gml:Curve/gml:segments/gml:LineStringSegment/gml:posList", doc));
    }

    @Test
    public void testEncodeMultiCurve() throws Exception {
        MultiLineStringEncoder encoder = new MultiLineStringEncoder(this.gtEncoder, "gml", "http://www.opengis.net/gml", true);
        Geometry geometry = new WKTReader2().read("MULTICURVE((105 105, 125 125), CIRCULARSTRING(-10 0, -8 2, -6 0, -8 -2, -10 0))");
        Document doc = this.encode(encoder, geometry);
        Assert.assertEquals((long)1L, (long)this.xpath.getMatchingNodes("//gml:MultiCurve", doc).getLength());
        Assert.assertEquals((long)2L, (long)this.xpath.getMatchingNodes("//gml:MultiCurve/gml:curveMember", doc).getLength());
        Assert.assertEquals((Object)"105 105 125 125", (Object)this.xpath.evaluate("//gml:MultiCurve/gml:curveMember[1]/gml:LineString/gml:posList", doc));
        Assert.assertEquals((long)1L, (long)this.xpath.getMatchingNodes("//gml:MultiCurve/gml:curveMember[2]/gml:Curve/gml:segments/*", doc).getLength());
        Assert.assertEquals((Object)"circularArc3Points", (Object)this.xpath.evaluate("/gml:MultiCurve/gml:curveMember[2]/gml:Curve/gml:segments/gml:ArcString/@interpolation", doc));
        Assert.assertEquals((Object)"-10 0 -8 2 -6 0 -8 -2 -10 0", (Object)this.xpath.evaluate("/gml:MultiCurve/gml:curveMember[2]/gml:Curve/gml:segments/gml:ArcString/gml:posList", doc));
    }

    @Test
    public void testEncodeMultiLineString() throws Exception {
        MultiLineStringEncoder encoder = new MultiLineStringEncoder(this.gtEncoder, "gml", "http://www.opengis.net/gml", false);
        Geometry geometry = new WKTReader2().read("MULTILINESTRING((105 105, 125 125))");
        Document doc = this.encode(encoder, geometry, "multi");
        Assert.assertEquals((long)1L, (long)this.xpath.getMatchingNodes("//gml:MultiLineString", doc).getLength());
        Assert.assertEquals((long)1L, (long)this.xpath.getMatchingNodes("//gml:MultiLineString/gml:lineStringMember", doc).getLength());
        Assert.assertEquals((Object)"105 105 125 125", (Object)this.xpath.evaluate("//gml:MultiLineString/gml:lineStringMember[1]/gml:LineString/gml:posList", doc));
        Assert.assertEquals((Object)"multi", (Object)this.xpath.evaluate("/gml:MultiLineString/@gml:id", doc));
        Assert.assertEquals((Object)"multi.1", (Object)this.xpath.evaluate("/gml:MultiLineString/gml:lineStringMember/gml:LineString/@gml:id", doc));
    }
}

