/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gml3.simple;

import org.geotools.geometry.jts.LiteCoordinateSequence;
import org.geotools.geometry.jts.WKTReader2;
import org.geotools.gml3.simple.GeometryEncoderTestSupport;
import org.geotools.gml3.simple.LineStringEncoder;
import org.junit.Assert;
import org.junit.Test;
import org.locationtech.jts.geom.CoordinateSequence;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineString;
import org.w3c.dom.Document;

public class LineString3DTest
extends GeometryEncoderTestSupport {
    @Test
    public void testEncode3DLine() throws Exception {
        LineStringEncoder encoder = new LineStringEncoder(this.gtEncoder, "gml", "http://www.opengis.net/gml");
        LineString geometry = (LineString)new WKTReader2().read("LINESTRING(0 0 50, 120 0 100)");
        Document doc = this.encode(encoder, geometry, "threed");
        Assert.assertEquals((Object)"0 0 50 120 0 100", (Object)this.xpath.evaluate("//gml:posList", doc));
        Assert.assertEquals((Object)"threed", (Object)this.xpath.evaluate("//gml:LineString/@gml:id", doc));
    }

    @Test
    public void testEncode3DLineFromLiteCS() throws Exception {
        LineStringEncoder encoder = new LineStringEncoder(this.gtEncoder, "gml", "http://www.opengis.net/gml");
        LiteCoordinateSequence cs = new LiteCoordinateSequence(new double[]{0.0, 0.0, 50.0, 120.0, 0.0, 100.0}, 3);
        LineString geometry = new GeometryFactory().createLineString((CoordinateSequence)cs);
        Document doc = this.encode(encoder, geometry);
        Assert.assertEquals((Object)"0 0 50 120 0 100", (Object)this.xpath.evaluate("//gml:posList", doc));
    }
}

