/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gml3.simple;

import org.geotools.geometry.jts.WKTReader2;
import org.geotools.gml3.simple.GeometryCollectionEncoder;
import org.geotools.gml3.simple.GeometryEncoderTestSupport;
import org.junit.Assert;
import org.junit.Test;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.io.ParseException;
import org.w3c.dom.Document;

public class GeometryCollectionEncoderTest
extends GeometryEncoderTestSupport {
    @Test
    public void testGeometryCollectionEncoder() throws ParseException, Exception {
        GeometryCollectionEncoder gce = new GeometryCollectionEncoder(this.gtEncoder, "gml", "http://www.opengis.net/gml");
        GeometryCollection geometry = (GeometryCollection)new WKTReader2().read("GEOMETRYCOLLECTION (LINESTRING (180 200, 160 180), POINT (19 19), POINT (20 10))");
        Document doc = this.encode(gce, geometry, "feature.1");
        Assert.assertEquals((long)1L, (long)this.xpath.getMatchingNodes("//gml:LineString", doc).getLength());
        Assert.assertEquals((long)2L, (long)this.xpath.getMatchingNodes("//gml:Point", doc).getLength());
        Assert.assertEquals((long)1L, (long)this.xpath.getMatchingNodes("//gml:MultiGeometry", doc).getLength());
        Assert.assertEquals((Object)"180 200 160 180", (Object)this.xpath.evaluate("//gml:MultiGeometry/gml:geometryMember/gml:LineString/gml:posList", doc));
        Assert.assertEquals((Object)"19 19", (Object)this.xpath.evaluate("//gml:MultiGeometry/gml:geometryMember/gml:Point/gml:pos", doc));
        Assert.assertEquals((Object)"feature.1", (Object)this.xpath.evaluate("//gml:MultiGeometry/@gml:id", doc));
        Assert.assertEquals((Object)"feature.1.1", (Object)this.xpath.evaluate("//gml:MultiGeometry/gml:geometryMember[1]/gml:LineString/@gml:id", doc));
        Assert.assertEquals((Object)"feature.1.2", (Object)this.xpath.evaluate("//gml:MultiGeometry/gml:geometryMember[2]/gml:Point/@gml:id", doc));
        Assert.assertEquals((Object)"feature.1.3", (Object)this.xpath.evaluate("//gml:MultiGeometry/gml:geometryMember[3]/gml:Point/@gml:id", doc));
    }
}

