/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gml3.bindings;

import java.util.ArrayList;
import java.util.Collections;
import javax.xml.namespace.QName;
import org.geotools.feature.AttributeImpl;
import org.geotools.feature.ComplexAttributeImpl;
import org.geotools.feature.NameImpl;
import org.geotools.feature.type.AttributeDescriptorImpl;
import org.geotools.feature.type.AttributeTypeImpl;
import org.geotools.feature.type.ComplexTypeImpl;
import org.geotools.gml3.GML3TestSupport;
import org.geotools.gml3.GMLConfiguration;
import org.geotools.xs.XSSchema;
import org.geotools.xsd.Configuration;
import org.geotools.xsd.SchemaLocator;
import org.geotools.xsd.XSD;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.opengis.feature.ComplexAttribute;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.feature.type.AttributeType;
import org.opengis.feature.type.Name;
import org.picocontainer.MutablePicoContainer;
import org.w3c.dom.Document;

public class XSAnyTypeBindingTest
extends GML3TestSupport {
    private static final String SAMPLE_CLASS_VALUE = "1.1.1";
    private static final String SAMPLE_UNRESTRICTED_VALUE = "Arbitrary text content: <value>XML</value> special characters will be escaped automatically.";

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.registerNamespaceMapping("test", "http://www.geotools.org/anytypetest");
    }

    @Override
    protected Configuration createConfiguration() {
        return new MyConfiguration();
    }

    @Test
    public void testEncode() throws Exception {
        QName observation = ANYTYPETEST.OBSERVATION;
        ComplexAttribute myCode = this.checkAnyTypeTest(observation, SAMPLE_CLASS_VALUE);
        Document dom = this.encode(myCode, observation);
        Assert.assertEquals((Object)"test:Observation", (Object)dom.getDocumentElement().getNodeName());
        Assert.assertEquals((long)1L, (long)dom.getDocumentElement().getElementsByTagName("test:class").getLength());
        Assert.assertNotNull((Object)dom.getDocumentElement().getElementsByTagName("test:class").item(0).getFirstChild());
        Assert.assertEquals((Object)SAMPLE_CLASS_VALUE, (Object)dom.getDocumentElement().getElementsByTagName("test:class").item(0).getFirstChild().getNodeValue());
    }

    @Test
    public void testEncodeUnrestricted() throws Exception {
        QName typeName = ANYTYPETEST.UNRESTRICTED;
        ComplexAttribute unrestricted = this.createUnrestrictedAttr(typeName, SAMPLE_UNRESTRICTED_VALUE);
        Document dom = this.encode(unrestricted, typeName);
        Assert.assertEquals((Object)"test:unrestrictedEl", (Object)dom.getDocumentElement().getNodeName());
        Assert.assertEquals((Object)SAMPLE_UNRESTRICTED_VALUE, (Object)dom.getDocumentElement().getTextContent());
    }

    public ComplexAttribute checkAnyTypeTest(QName typeName, String classValue) {
        NameImpl myType = new NameImpl(typeName.getNamespaceURI(), typeName.getLocalPart());
        ArrayList<AttributeImpl> properties = new ArrayList<AttributeImpl>();
        ArrayList<AttributeDescriptorImpl> propertyDescriptors = new ArrayList<AttributeDescriptorImpl>();
        NameImpl attName = new NameImpl(typeName.getNamespaceURI(), "class");
        AttributeTypeImpl p = new AttributeTypeImpl((Name)attName, String.class, false, false, null, null, null);
        AttributeDescriptorImpl pd = new AttributeDescriptorImpl((AttributeType)p, (Name)attName, 0, 0, false, null);
        propertyDescriptors.add(pd);
        properties.add(new AttributeImpl((Object)classValue, (AttributeDescriptor)pd, null));
        ComplexTypeImpl at = new ComplexTypeImpl((Name)myType, propertyDescriptors, false, false, Collections.emptyList(), null, null);
        AttributeDescriptorImpl ai = new AttributeDescriptorImpl((AttributeType)at, (Name)myType, 0, 0, false, null);
        return new ComplexAttributeImpl(properties, (AttributeDescriptor)ai, null);
    }

    public ComplexAttribute createUnrestrictedAttr(QName typeName, String contents) {
        NameImpl unrestrictedType = new NameImpl(typeName.getNamespaceURI(), typeName.getLocalPart());
        ArrayList<AttributeImpl> properties = new ArrayList<AttributeImpl>();
        ArrayList<AttributeDescriptorImpl> propertyDescriptors = new ArrayList<AttributeDescriptorImpl>();
        NameImpl attName = new NameImpl(null, "simpleContent");
        AttributeTypeImpl p = new AttributeTypeImpl((Name)attName, String.class, false, false, null, null, null);
        AttributeDescriptorImpl pd = new AttributeDescriptorImpl((AttributeType)p, (Name)attName, 0, 0, true, null);
        propertyDescriptors.add(pd);
        properties.add(new AttributeImpl((Object)contents, (AttributeDescriptor)pd, null));
        ComplexTypeImpl at = new ComplexTypeImpl((Name)unrestrictedType, propertyDescriptors, false, false, Collections.emptyList(), XSSchema.ANYTYPE_TYPE, null);
        AttributeDescriptorImpl ai = new AttributeDescriptorImpl((AttributeType)at, (Name)unrestrictedType, 0, 0, false, null);
        return new ComplexAttributeImpl(properties, (AttributeDescriptor)ai, null);
    }

    class MyConfiguration
    extends Configuration {
        public MyConfiguration() {
            super((XSD)ANYTYPETEST.getInstance());
            this.addDependency((Configuration)new GMLConfiguration());
        }
    }

    class AnyTypeTestConfiguration
    extends Configuration {
        public AnyTypeTestConfiguration() {
            super((XSD)ANYTYPETEST.getInstance());
        }

        protected void registerBindings(MutablePicoContainer container) {
        }
    }

    static class ANYTYPETEST
    extends XSD {
        private static ANYTYPETEST instance = new ANYTYPETEST();
        public static final String NAMESPACE = "http://www.geotools.org/anytypetest";
        public static final QName OBSERVATION = new QName("http://www.geotools.org/anytypetest", "Observation");
        public static final QName UNRESTRICTED = new QName("http://www.geotools.org/anytypetest", "unrestrictedEl");

        private ANYTYPETEST() {
        }

        public static ANYTYPETEST getInstance() {
            return instance;
        }

        public String getNamespaceURI() {
            return NAMESPACE;
        }

        public String getSchemaLocation() {
            return ((Object)((Object)this)).getClass().getResource("AnyTypeTest.xsd").toString();
        }

        public SchemaLocator createSchemaLocator() {
            return null;
        }
    }
}

