/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gml3.bindings;

import org.geotools.gml3.GML;
import org.geotools.gml3.GML3TestSupport;
import org.geotools.gml3.bindings.GML3EncodingUtils;
import org.geotools.gml3.bindings.GML3MockData;
import org.junit.Assert;
import org.junit.Test;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.MultiPoint;
import org.locationtech.jts.geom.Point;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;

public class MultiPointTypeBindingTest
extends GML3TestSupport {
    @Test
    public void test() throws Exception {
        GML3MockData.multiPoint(this.document, this.document);
        MultiPoint multiPoint = (MultiPoint)this.parse();
        Assert.assertNotNull((Object)multiPoint);
        Assert.assertEquals((long)4L, (long)multiPoint.getNumPoints());
    }

    @Test
    public void test3D() throws Exception {
        GML3MockData.multiPoint3D(this.document, this.document);
        MultiPoint multiPoint = (MultiPoint)this.parse();
        Assert.assertNotNull((Object)multiPoint);
        Assert.assertEquals((long)4L, (long)multiPoint.getNumPoints());
        Point p = (Point)multiPoint.getGeometryN(0);
        Assert.assertTrue((boolean)new Coordinate(1.0, 2.0, 10.0).equals3D(p.getCoordinate()));
    }

    @Test
    public void testEncode() throws Exception {
        MultiPoint geometry = GML3MockData.multiPoint();
        GML3EncodingUtils.setID((Geometry)geometry, (String)"geometry");
        Document dom = this.encode(geometry, GML.MultiPoint);
        Assert.assertEquals((Object)"geometry", (Object)this.getID(dom.getDocumentElement()));
        Assert.assertEquals((long)2L, (long)dom.getElementsByTagNameNS("http://www.opengis.net/gml", "pointMember").getLength());
        NodeList children = dom.getElementsByTagNameNS("http://www.opengis.net/gml", GML.Point.getLocalPart());
        Assert.assertEquals((long)2L, (long)children.getLength());
        Assert.assertEquals((Object)"geometry.1", (Object)this.getID(children.item(0)));
        Assert.assertEquals((Object)"geometry.2", (Object)this.getID(children.item(1)));
    }
}

