/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gml3.bindings;

import org.geotools.gml3.GML;
import org.geotools.gml3.GML3TestSupport;
import org.geotools.gml3.bindings.GML3EncodingUtils;
import org.geotools.gml3.bindings.GML3MockData;
import org.junit.Assert;
import org.junit.Test;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.MultiLineString;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;

public class MultiLineStringTypeBindingTest
extends GML3TestSupport {
    @Test
    public void test() throws Exception {
        GML3MockData.multiLineString(this.document, this.document);
        MultiLineString multiLineString = (MultiLineString)this.parse();
        Assert.assertNotNull((Object)multiLineString);
        Assert.assertEquals((long)2L, (long)multiLineString.getNumGeometries());
    }

    @Test
    public void test3D() throws Exception {
        GML3MockData.multiLineString3D(this.document, this.document);
        MultiLineString multiLineString = (MultiLineString)this.parse();
        Assert.assertNotNull((Object)multiLineString);
        Assert.assertEquals((long)2L, (long)multiLineString.getNumGeometries());
        LineString line = (LineString)multiLineString.getGeometryN(0);
        Assert.assertTrue((boolean)new Coordinate(1.0, 2.0, 10.0).equals3D(line.getPointN(0).getCoordinate()));
        Assert.assertTrue((boolean)new Coordinate(3.0, 4.0, 20.0).equals3D(line.getPointN(1).getCoordinate()));
    }

    @Test
    public void testEncode() throws Exception {
        MultiLineString geometry = GML3MockData.multiLineString();
        GML3EncodingUtils.setID((Geometry)geometry, (String)"geometry");
        Document dom = this.encode(geometry, GML.MultiLineString);
        Assert.assertEquals((Object)"geometry", (Object)this.getID(dom.getDocumentElement()));
        Assert.assertEquals((long)2L, (long)dom.getElementsByTagNameNS("http://www.opengis.net/gml", "lineStringMember").getLength());
        NodeList children = dom.getElementsByTagNameNS("http://www.opengis.net/gml", GML.LineString.getLocalPart());
        Assert.assertEquals((long)2L, (long)children.getLength());
        Assert.assertEquals((Object)"geometry.1", (Object)this.getID(children.item(0)));
        Assert.assertEquals((Object)"geometry.2", (Object)this.getID(children.item(1)));
        this.checkDimension(dom, GML.MultiLineString.getLocalPart(), 2);
        this.checkDimension(dom, GML.LineString.getLocalPart(), 2);
        this.checkPosListOrdinates(dom, 2 * geometry.getGeometryN(0).getNumPoints());
    }
}

