/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gml3.bindings;

import org.custommonkey.xmlunit.XMLUnit;
import org.custommonkey.xmlunit.XpathEngine;
import org.geotools.geometry.jts.CurvedGeometryFactory;
import org.geotools.geometry.jts.LiteCoordinateSequence;
import org.geotools.gml3.GML;
import org.geotools.gml3.GML3TestSupport;
import org.geotools.gml3.GMLConfiguration;
import org.geotools.gml3.bindings.GML3MockData;
import org.geotools.xsd.Configuration;
import org.junit.Assert;
import org.junit.Test;
import org.locationtech.jts.geom.CoordinateSequence;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.io.WKTReader;
import org.w3c.dom.Document;

public class GeometryPropertyTypeBindingTest
extends GML3TestSupport {
    @Override
    protected boolean enableExtendedArcSurfaceSupport() {
        return true;
    }

    @Override
    protected Configuration createConfiguration() {
        GMLConfiguration configuration = new GMLConfiguration(this.enableExtendedArcSurfaceSupport());
        configuration.setNumDecimals(2);
        return configuration;
    }

    @Test
    public void testEncode() throws Exception {
        Document dom = this.encode(GML3MockData.point(), GML.geometryMember);
        Assert.assertEquals((long)1L, (long)dom.getElementsByTagNameNS("http://www.opengis.net/gml", "Point").getLength());
    }

    @Test
    public void testEncodeCurve() throws Exception {
        LineString curve = new CurvedGeometryFactory(0.1).createCurvedGeometry((CoordinateSequence)new LiteCoordinateSequence(new double[]{1.0, 1.0, 2.0, 2.0, 3.0, 1.0, 5.0, 5.0, 7.0, 3.0}));
        Document dom = this.encode(curve, GML.geometryMember);
        XpathEngine xpath = XMLUnit.newXpathEngine();
        String basePath = "/gml:geometryMember/gml:Curve/gml:segments/gml:ArcString";
        Assert.assertEquals((long)1L, (long)xpath.getMatchingNodes(basePath + "[@interpolation='circularArc3Points']", dom).getLength());
        Assert.assertEquals((Object)"1 1 2 2 3 1 5 5 7 3", (Object)xpath.evaluate(basePath + "/gml:posList", dom));
    }

    @Test
    public void testEncodePointWithDecimals() throws Exception {
        Geometry geometry = new WKTReader().read("POINT(1.234 5.678)");
        Document dom = this.encode(geometry, GML.geometryMember);
        XpathEngine xpath = XMLUnit.newXpathEngine();
        Assert.assertEquals((Object)"1.23 5.68", (Object)xpath.evaluate("/gml:geometryMember/gml:Point/gml:pos", dom));
    }
}

