/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gml3.bindings;

import org.geotools.geometry.DirectPosition1D;
import org.geotools.geometry.DirectPosition2D;
import org.geotools.gml3.GML;
import org.geotools.gml3.GML3TestSupport;
import org.geotools.gml3.bindings.GML3MockData;
import org.junit.Assert;
import org.junit.Test;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.CoordinateSequence;
import org.locationtech.jts.geom.CoordinateXYM;
import org.locationtech.jts.geom.CoordinateXYZM;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.Point;
import org.opengis.geometry.DirectPosition;
import org.w3c.dom.Document;

public class DirectPositionTypeBindingTest
extends GML3TestSupport {
    @Test
    public void test1D() throws Exception {
        GML3MockData.element(GML.pos, this.document, this.document);
        this.document.getDocumentElement().appendChild(this.document.createTextNode("1.0"));
        DirectPosition pos = (DirectPosition)this.parse();
        Assert.assertNotNull((Object)pos);
        Assert.assertTrue((boolean)(pos instanceof DirectPosition1D));
        Assert.assertEquals((double)pos.getOrdinate(0), (double)1.0, (double)0.0);
    }

    @Test
    public void test2D() throws Exception {
        GML3MockData.element(GML.pos, this.document, this.document);
        this.document.getDocumentElement().appendChild(this.document.createTextNode("1.0 2.0"));
        DirectPosition pos = (DirectPosition)this.parse();
        Assert.assertNotNull((Object)pos);
        Assert.assertTrue((boolean)(pos instanceof DirectPosition2D));
        Assert.assertEquals((double)pos.getOrdinate(0), (double)1.0, (double)0.0);
        Assert.assertEquals((double)pos.getOrdinate(1), (double)2.0, (double)0.0);
    }

    @Test
    public void testEncode2D() throws Exception {
        Point point = GML3MockData.pointLite2D();
        CoordinateSequence seq = point.getCoordinateSequence();
        Document doc = this.encode(seq, GML.pos);
        this.checkPosOrdinates(doc, 2);
    }

    @Test
    public void testEncode3D() throws Exception {
        Point point = GML3MockData.pointLite3D();
        CoordinateSequence seq = point.getCoordinateSequence();
        Document doc = this.encode(seq, GML.pos);
        this.checkPosOrdinates(doc, 3);
    }

    @Test
    public void testEncodeXYM() throws Exception {
        GeometryFactory gf = new GeometryFactory();
        Point pointM = gf.createPoint((Coordinate)new CoordinateXYM(1.0, 1.0, 4.0));
        CoordinateSequence seq = pointM.getCoordinateSequence();
        Document doc = this.encode(seq, GML.pos);
        this.checkPosOrdinates(doc, 4);
    }

    @Test
    public void testEncodeZM() throws Exception {
        GeometryFactory gf = new GeometryFactory();
        Point pointM = gf.createPoint((Coordinate)new CoordinateXYZM(1.0, 1.0, 2.0, 4.0));
        CoordinateSequence seq = pointM.getCoordinateSequence();
        Document doc = this.encode(seq, GML.pos);
        this.checkPosOrdinates(doc, 4);
    }
}

