/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gml3;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.HashMap;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.custommonkey.xmlunit.NamespaceContext;
import org.custommonkey.xmlunit.SimpleNamespaceContext;
import org.custommonkey.xmlunit.XMLUnit;
import org.eclipse.xsd.XSDSchema;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.gml3.ApplicationSchemaConfiguration;
import org.geotools.gml3.bindings.TEST;
import org.geotools.gml3.bindings.TestConfiguration;
import org.geotools.xsd.Configuration;
import org.geotools.xsd.Encoder;
import org.geotools.xsd.Parser;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class GML3EncodingOnlineTest {
    @Before
    public void setUp() throws Exception {
        HashMap<String, String> namespaces = new HashMap<String, String>();
        namespaces.put("test", TEST.TestFeature.getNamespaceURI());
        XMLUnit.setXpathNamespaceContext((NamespaceContext)new SimpleNamespaceContext(namespaces));
    }

    boolean isOffline() throws Exception {
        URL url = new URL("http://schemas.opengis.net");
        try {
            URLConnection conn = url.openConnection();
            conn.setConnectTimeout(2000);
            conn.getInputStream().read();
        }
        catch (Exception e) {
            return true;
        }
        return false;
    }

    @Test
    public void testWithConfiguration() throws Exception {
        if (this.isOffline()) {
            return;
        }
        TestConfiguration configuration = new TestConfiguration();
        Parser parser = new Parser((Configuration)configuration);
        SimpleFeatureCollection fc = (SimpleFeatureCollection)parser.parse(TestConfiguration.class.getResourceAsStream("test.xml"));
        Assert.assertNotNull((Object)fc);
        XSDSchema schema = TEST.getInstance().getSchema();
        Assert.assertNotNull((Object)schema);
        Encoder encoder = new Encoder((Configuration)configuration, schema);
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        encoder.encode((Object)fc, TEST.TestFeatureCollection, (OutputStream)output);
        this.validate(output.toByteArray(), configuration);
    }

    @Test
    public void testWithApplicationSchemaConfiguration() throws Exception {
        if (this.isOffline()) {
            return;
        }
        String schemaLocation = TestConfiguration.class.getResource("test.xsd").toString();
        ApplicationSchemaConfiguration configuration = new ApplicationSchemaConfiguration(TEST.NAMESPACE, schemaLocation);
        Parser parser = new Parser((Configuration)configuration);
        SimpleFeatureCollection fc = (SimpleFeatureCollection)parser.parse(TestConfiguration.class.getResourceAsStream("test.xml"));
        Assert.assertNotNull((Object)fc);
        XSDSchema schema = TEST.getInstance().getSchema();
        Assert.assertNotNull((Object)schema);
        Encoder encoder = new Encoder((Configuration)configuration, schema);
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        encoder.encode((Object)fc, TEST.TestFeatureCollection, (OutputStream)output);
        this.validate(output.toByteArray(), (Configuration)configuration);
    }

    void validate(byte[] data, Configuration configuration) throws Exception {
        SchemaFactory sf = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        Schema s = sf.newSchema(new URI(configuration.getXSD().getSchemaLocation()).toURL());
        Validator v = s.newValidator();
        final ArrayList errors = new ArrayList();
        DefaultHandler handler = new DefaultHandler(){

            @Override
            public void error(SAXParseException e) throws SAXException {
                errors.add(e);
            }

            @Override
            public void fatalError(SAXParseException e) throws SAXException {
                errors.add(e);
            }
        };
        v.setErrorHandler(handler);
        v.validate(new StreamSource(new ByteArrayInputStream(data)));
        Assert.assertTrue((boolean)errors.isEmpty());
    }
}

