/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gml3.bindings;

import javax.xml.namespace.QName;
import org.geotools.geometry.jts.CurvedGeometryFactory;
import org.geotools.geometry.jts.SingleCurvedGeometry;
import org.geotools.gml3.ArcParameters;
import org.geotools.gml3.GML;
import org.geotools.gml3.bindings.GML3ParsingUtils;
import org.geotools.xsd.AbstractComplexBinding;
import org.geotools.xsd.ElementInstance;
import org.geotools.xsd.Node;
import org.locationtech.jts.geom.CoordinateSequence;
import org.locationtech.jts.geom.CoordinateSequenceFactory;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineString;

public class ArcTypeBinding
extends AbstractComplexBinding {
    GeometryFactory gFactory;
    CoordinateSequenceFactory csFactory;
    ArcParameters arcParameters;

    public ArcTypeBinding(GeometryFactory gFactory, CoordinateSequenceFactory csFactory, ArcParameters arcParameters) {
        this.gFactory = gFactory;
        this.csFactory = csFactory;
        this.arcParameters = arcParameters;
    }

    public QName getTarget() {
        return GML.ArcType;
    }

    public Class getType() {
        return SingleCurvedGeometry.class;
    }

    public int getExecutionMode() {
        return 0;
    }

    public Object parse(ElementInstance instance, Node node, Object value) throws Exception {
        LineString arcLineString = GML3ParsingUtils.lineString(node, this.gFactory, this.csFactory);
        CoordinateSequence cs = arcLineString.getCoordinateSequence();
        if (cs.size() < 3) {
            throw new RuntimeException("Number of coordinates in an arc string must be at least 3, " + cs.size() + " were specified: " + String.valueOf(arcLineString));
        }
        CurvedGeometryFactory factory = GML3ParsingUtils.getCurvedGeometryFactory(this.arcParameters, this.gFactory, cs);
        return factory.createCurvedGeometry(cs);
    }
}

