/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gml2.bindings;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import org.eclipse.xsd.XSDElementDeclaration;
import org.eclipse.xsd.XSDFeature;
import org.eclipse.xsd.XSDParticle;
import org.eclipse.xsd.XSDTypeDefinition;
import org.geotools.feature.NameImpl;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.gml2.FeatureTypeCache;
import org.geotools.gml2.bindings.GML2EncodingUtils;
import org.geotools.referencing.CRS;
import org.geotools.util.Converters;
import org.geotools.util.logging.Logging;
import org.geotools.xs.bindings.XSAnyTypeBinding;
import org.geotools.xsd.Binding;
import org.geotools.xsd.BindingWalkerFactory;
import org.geotools.xsd.ElementInstance;
import org.geotools.xsd.Node;
import org.geotools.xsd.Schemas;
import org.geotools.xsd.impl.BindingWalker;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.MultiLineString;
import org.locationtech.jts.geom.MultiPoint;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.feature.type.AttributeType;
import org.opengis.feature.type.FeatureType;
import org.opengis.feature.type.Name;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.NoSuchAuthorityCodeException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class GML2ParsingUtils {
    static Logger LOGGER = Logging.getLogger(GML2ParsingUtils.class);
    public static String PARSED_FROM_SCHEMA_KEY;

    public static SimpleFeature parseFeature(ElementInstance instance, Node node, Object value, FeatureTypeCache ftCache, BindingWalkerFactory bwFactory) throws Exception {
        String fid;
        XSDElementDeclaration decl = instance.getElementDeclaration();
        SimpleFeatureType sfType = null;
        FeatureType fType = null;
        if (!decl.isAbstract()) {
            fType = ftCache.get((Name)new NameImpl(decl.getTargetNamespace(), decl.getName()));
            if (fType != null && !(fType instanceof SimpleFeatureType)) {
                throw new UnsupportedOperationException("Parsing of non-simple GML features not yet supported.");
            }
            sfType = (SimpleFeatureType)fType;
            if (sfType == null) {
                CoordinateReferenceSystem crs = null;
                if (node.hasChild("boundedBy") && node.getChild("boundedBy").hasChild("Box")) {
                    crs = GML2ParsingUtils.crs(node.getChild("boundedBy").getChild("Box"));
                } else if (node.hasChild("boundedBy") && node.getChild("boundedBy").hasChild("Envelope")) {
                    crs = GML2ParsingUtils.crs(node.getChild("boundedBy").getChild("Envelope"));
                }
                sfType = GML2ParsingUtils.featureType(decl, bwFactory, crs);
                ftCache.put((FeatureType)sfType);
            }
        } else {
            fType = ftCache.get((Name)new NameImpl(node.getComponent().getNamespace(), node.getComponent().getName()));
            if (fType != null && !(fType instanceof SimpleFeatureType)) {
                throw new UnsupportedOperationException("Parsing of non-simple GML features not yet supported.");
            }
            sfType = (SimpleFeatureType)fType;
            if (sfType == null) {
                sfType = GML2ParsingUtils.featureType(node);
                ftCache.put((FeatureType)sfType);
            }
        }
        if ((fid = (String)node.getAttributeValue("fid")) == null) {
            fid = (String)node.getAttributeValue("id");
        }
        return GML2ParsingUtils.feature(sfType, fid, node);
    }

    public static SimpleFeatureType featureType(Node node) throws Exception {
        SimpleFeatureTypeBuilder ftBuilder = new SimpleFeatureTypeBuilder();
        ftBuilder.setName(node.getComponent().getName());
        ftBuilder.setNamespaceURI(node.getComponent().getNamespace());
        ftBuilder.setCRS(null);
        CoordinateReferenceSystem crs = null;
        if (!node.hasChild("description")) {
            ftBuilder.add("description", String.class);
        }
        if (!node.hasChild("name")) {
            ftBuilder.add("name", String.class);
        }
        if (!node.hasChild("boundedBy")) {
            ftBuilder.add("boundedBy", ReferencedEnvelope.class);
        } else if (node.getChild("boundedBy").hasChild("Box")) {
            crs = GML2ParsingUtils.crs(node.getChild("boundedBy").getChild("Box"));
        } else if (node.getChild("boundedBy").hasChild("Envelope")) {
            crs = GML2ParsingUtils.crs(node.getChild("boundedBy").getChild("Envelope"));
        }
        for (Node child : node.getChildren()) {
            String name = child.getComponent().getName();
            Object value = child.getValue();
            if (value != null && Geometry.class.isAssignableFrom(value.getClass()) && crs != null) {
                ftBuilder.crs(crs);
            }
            ftBuilder.add(name, value != null ? value.getClass() : Object.class);
        }
        ftBuilder.userData((Object)PARSED_FROM_SCHEMA_KEY, (Object)false);
        return ftBuilder.buildFeatureType();
    }

    public static SimpleFeatureType featureType(XSDElementDeclaration element, BindingWalkerFactory bwFactory) throws Exception {
        return GML2ParsingUtils.featureType(element, bwFactory, null);
    }

    public static SimpleFeatureType featureType(XSDElementDeclaration element, BindingWalkerFactory bwFactory, CoordinateReferenceSystem crs) throws Exception {
        SimpleFeatureTypeBuilder ftBuilder = new SimpleFeatureTypeBuilder();
        ftBuilder.setName(element.getName());
        ftBuilder.setNamespaceURI(element.getTargetNamespace());
        List children = Schemas.getChildElementParticles((XSDTypeDefinition)element.getType(), (boolean)true);
        for (XSDParticle particle : children) {
            Binding last;
            Class theClass;
            XSDElementDeclaration property = (XSDElementDeclaration)particle.getContent();
            if (property.isElementDeclarationReference()) {
                property = property.getResolvedElementDeclaration();
            }
            final ArrayList<XSAnyTypeBinding> bindings = new ArrayList<XSAnyTypeBinding>();
            BindingWalker.Visitor visitor = new BindingWalker.Visitor(){

                public void visit(Binding binding) {
                    bindings.add(binding);
                }
            };
            bwFactory.walk((XSDFeature)property, visitor);
            if (bindings.isEmpty()) {
                LOGGER.fine("Could not find binding for " + property.getQName() + ", using XSAnyTypeBinding.");
                bindings.add(new XSAnyTypeBinding());
            }
            if ((theClass = (last = (Binding)bindings.get(bindings.size() - 1)).getType()) == null) {
                throw new RuntimeException("binding declares null type: " + last.getTarget());
            }
            int min = particle.getMinOccurs();
            int max = particle.getMaxOccurs();
            if (min == -1) {
                min = 0;
            }
            if (max == -1) {
                max = 1;
            }
            if (Geometry.class.isAssignableFrom(theClass) && crs != null) {
                ftBuilder.crs(crs);
            }
            ftBuilder.minOccurs(min).maxOccurs(max).add(property.getName(), theClass);
            String propNamespace = property.getTargetNamespace();
            if (!Geometry.class.isAssignableFrom(theClass) || propNamespace != null && propNamespace.startsWith("http://www.opengis.net/gml") || ftBuilder.getDefaultGeometry() != null) continue;
            ftBuilder.setDefaultGeometry(property.getName());
        }
        ftBuilder.userData((Object)PARSED_FROM_SCHEMA_KEY, (Object)true);
        return ftBuilder.buildFeatureType();
    }

    public static SimpleFeature feature(SimpleFeatureType fType, String fid, Node node) throws Exception {
        SimpleFeatureBuilder b = new SimpleFeatureBuilder(fType);
        int attributeCount = fType.getAttributeCount();
        for (int i = 0; i < attributeCount; ++i) {
            Object converted;
            AttributeDescriptor att = fType.getDescriptor(i);
            AttributeType attType = att.getType();
            Object attValue = node.getChildValue(att.getLocalName());
            if (attValue != null && !attType.getBinding().isAssignableFrom(attValue.getClass()) && (converted = Converters.convert((Object)attValue, (Class)attType.getBinding())) != null) {
                attValue = converted;
            }
            b.add(attValue);
        }
        return b.buildFeature(fid);
    }

    public static CoordinateReferenceSystem crs(Node node) {
        if (node.getAttribute("srsName") != null) {
            URI srs = null;
            Object raw = node.getAttributeValue("srsName");
            if (raw instanceof URI) {
                srs = (URI)raw;
            } else if (raw instanceof String) {
                try {
                    srs = new URI((String)raw);
                }
                catch (URISyntaxException uRISyntaxException) {
                    // empty catch block
                }
            }
            if (srs != null && "http".equals(srs.getScheme()) && "www.opengis.net".equals(srs.getAuthority()) && "/gml/srs/epsg.xml".equals(srs.getPath()) && srs.getFragment() != null) {
                try {
                    return CRS.decode((String)("EPSG:" + srs.getFragment()));
                }
                catch (Exception e) {
                    try {
                        return CRS.decode((String)srs.toString());
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
            try {
                return CRS.decode((String)raw.toString());
            }
            catch (NoSuchAuthorityCodeException e) {
                String crs = raw.toString();
                if (crs.toUpperCase().startsWith("URN")) {
                    String code = crs.substring(crs.lastIndexOf(":") + 1);
                    try {
                        return CRS.decode((String)("EPSG:" + code));
                    }
                    catch (Exception e1) {
                        throw new RuntimeException("Could not create crs: " + srs, e);
                    }
                }
            }
            catch (FactoryException e) {
                throw new RuntimeException("Could not create crs: " + srs, e);
            }
        }
        return null;
    }

    public static Collection asCollection(GeometryCollection gc) {
        ArrayList<Geometry> members = new ArrayList<Geometry>();
        for (int i = 0; i < gc.getNumGeometries(); ++i) {
            members.add(gc.getGeometryN(i));
        }
        return members;
    }

    static GeometryCollection GeometryCollectionType_parse(Node node, Class clazz, GeometryFactory gFactory) {
        ArrayList<Object> geoms = new ArrayList<Object>();
        for (Node cnode : node.getChildren()) {
            if (!(cnode.getValue() instanceof Geometry)) continue;
            geoms.add(cnode.getValue());
        }
        Object gc = null;
        gc = MultiPoint.class.isAssignableFrom(clazz) ? gFactory.createMultiPoint(geoms.toArray(new Point[geoms.size()])) : (MultiLineString.class.isAssignableFrom(clazz) ? gFactory.createMultiLineString(geoms.toArray(new LineString[geoms.size()])) : (MultiPolygon.class.isAssignableFrom(clazz) ? gFactory.createMultiPolygon(geoms.toArray(new Polygon[geoms.size()])) : gFactory.createGeometryCollection(geoms.toArray(new Geometry[geoms.size()]))));
        CoordinateReferenceSystem crs = GML2ParsingUtils.crs(node);
        if (crs != null) {
            gc.setUserData((Object)crs);
            try {
                gc.setSRID(CRS.lookupEpsgCode((CoordinateReferenceSystem)crs, (boolean)true).intValue());
            }
            catch (FactoryException factoryException) {
                // empty catch block
            }
        }
        return gc;
    }

    static Object GeometryCollectionType_getProperty(Object object, QName name) {
        CoordinateReferenceSystem crs;
        if ("srsName".equals(name.getLocalPart()) && (crs = GML2EncodingUtils.getCRS((Geometry)((GeometryCollection)object))) != null) {
            return GML2EncodingUtils.toURI(crs, true);
        }
        return null;
    }
}

