/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter.v1_1;

import org.geotools.api.filter.PropertyIsLike;
import org.geotools.filter.v1_0.OGC;
import org.geotools.filter.v1_1.FilterMockData;
import org.geotools.filter.v1_1.FilterTestSupport;
import org.junit.Assert;
import org.junit.Test;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class OGCPropertyIsLikeTypeBindingTest
extends FilterTestSupport {
    @Test
    public void testParse() throws Exception {
        FilterMockData.propertyIsLike(this.document, this.document);
        PropertyIsLike isLike = (PropertyIsLike)this.parse();
        Assert.assertNotNull((Object)isLike.getExpression());
        Assert.assertNotNull((Object)isLike.getLiteral());
        Assert.assertEquals((Object)"x", (Object)isLike.getWildCard());
        Assert.assertEquals((Object)"y", (Object)isLike.getSingleChar());
        Assert.assertEquals((Object)"z", (Object)isLike.getEscape());
        Assert.assertFalse((boolean)isLike.isMatchingCase());
    }

    @Test
    public void testEncode() throws Exception {
        Document doc = this.encode(FilterMockData.propertyIsLike(), OGC.PropertyIsLike);
        Element pn = this.getElementByQName(doc, OGC.PropertyName);
        Assert.assertNotNull((Object)pn);
        Assert.assertEquals((Object)"foo", (Object)pn.getFirstChild().getNodeValue());
        Element l = this.getElementByQName(doc, OGC.Literal);
        Assert.assertEquals((Object)"foo", (Object)l.getFirstChild().getNodeValue());
        Assert.assertEquals((Object)"x", (Object)doc.getDocumentElement().getAttribute("wildCard"));
        Assert.assertEquals((Object)"y", (Object)doc.getDocumentElement().getAttribute("singleChar"));
        Assert.assertEquals((Object)"z", (Object)doc.getDocumentElement().getAttribute("escapeChar"));
        Assert.assertEquals((Object)"false", (Object)doc.getDocumentElement().getAttribute("matchCase"));
    }

    @Test
    public void testEncodeAsFilter() throws Exception {
        Document doc = this.encode(FilterMockData.propertyIsLike(), OGC.Filter);
        Assert.assertEquals((long)1L, (long)doc.getDocumentElement().getElementsByTagNameNS("http://www.opengis.net/ogc", OGC.PropertyName.getLocalPart()).getLength());
        Assert.assertEquals((long)1L, (long)doc.getDocumentElement().getElementsByTagNameNS("http://www.opengis.net/ogc", OGC.Literal.getLocalPart()).getLength());
        Element e = this.getElementByQName(doc, OGC.PropertyIsLike);
        Assert.assertEquals((Object)"x", (Object)e.getAttribute("wildCard"));
        Assert.assertEquals((Object)"y", (Object)e.getAttribute("singleChar"));
        Assert.assertEquals((Object)"z", (Object)e.getAttribute("escapeChar"));
        Assert.assertEquals((Object)"false", (Object)e.getAttribute("matchCase"));
    }
}

