/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter.v1_0;

import org.geotools.api.filter.And;
import org.geotools.api.filter.BinaryLogicOperator;
import org.geotools.api.filter.Filter;
import org.geotools.api.filter.FilterFactory;
import org.geotools.api.filter.Or;
import org.geotools.api.filter.PropertyIsBetween;
import org.geotools.api.filter.PropertyIsLike;
import org.geotools.api.filter.PropertyIsNull;
import org.geotools.filter.v1_0.FilterMockData;
import org.geotools.filter.v1_0.FilterTestSupport;
import org.geotools.filter.v1_0.OGC;
import org.junit.Assert;
import org.junit.Test;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class BinaryLogicOpTypeBindingTest
extends FilterTestSupport {
    @Test
    public void testBinaryLogicOpType() {
        Assert.assertEquals(BinaryLogicOperator.class, (Object)this.binding(OGC.BinaryLogicOpType).getType());
    }

    @Test
    public void testAndType() {
        Assert.assertEquals(And.class, (Object)this.binding(OGC.And).getType());
    }

    @Test
    public void testAndExecutionMode() {
        Assert.assertEquals((long)0L, (long)this.binding(OGC.And).getExecutionMode());
    }

    @Test
    public void testAndParse() throws Exception {
        FilterMockData.and(this.document, this.document);
        And and = (And)this.parse();
        Assert.assertEquals((long)2L, (long)and.getChildren().size());
    }

    @Test
    public void testAndEncode() throws Exception {
        Document dom = this.encode(FilterMockData.and(), OGC.And);
        Assert.assertEquals((long)1L, (long)dom.getElementsByTagNameNS("http://www.opengis.net/ogc", OGC.PropertyIsEqualTo.getLocalPart()).getLength());
        Assert.assertEquals((long)1L, (long)dom.getElementsByTagNameNS("http://www.opengis.net/ogc", OGC.PropertyIsNotEqualTo.getLocalPart()).getLength());
    }

    @Test
    public void testOrType() {
        Assert.assertEquals(Or.class, (Object)this.binding(OGC.Or).getType());
    }

    @Test
    public void testOrExecutionMode() {
        Assert.assertEquals((long)0L, (long)this.binding(OGC.Or).getExecutionMode());
    }

    @Test
    public void testOrParse() throws Exception {
        FilterMockData.or(this.document, this.document);
        Or or = (Or)this.parse();
        Assert.assertEquals((long)2L, (long)or.getChildren().size());
    }

    @Test
    public void testOrEncode() throws Exception {
        Document dom = this.encode(FilterMockData.or(), OGC.Or);
        Assert.assertEquals((long)1L, (long)dom.getElementsByTagNameNS("http://www.opengis.net/ogc", OGC.PropertyIsEqualTo.getLocalPart()).getLength());
        Assert.assertEquals((long)1L, (long)dom.getElementsByTagNameNS("http://www.opengis.net/ogc", OGC.PropertyIsNotEqualTo.getLocalPart()).getLength());
    }

    @Test
    public void testAndWithLikeParse() throws Exception {
        Element e = FilterMockData.and(this.document, this.document, true);
        FilterMockData.propertyIsLike(this.document, e);
        FilterMockData.propertyIsLike(this.document, e);
        And and = (And)this.parse();
        Assert.assertEquals((long)2L, (long)and.getChildren().size());
        Assert.assertTrue((boolean)(and.getChildren().get(0) instanceof PropertyIsLike));
        Assert.assertTrue((boolean)(and.getChildren().get(1) instanceof PropertyIsLike));
    }

    @Test
    public void testAndWithLikeEncode() throws Exception {
        FilterFactory f = FilterMockData.f;
        And and = f.and((Filter)FilterMockData.propertyIsLike(), (Filter)FilterMockData.propertyIsLike());
        Document dom = this.encode(and, OGC.And);
        Assert.assertEquals((long)2L, (long)this.getElementsByQName(dom, OGC.PropertyIsLike).getLength());
    }

    @Test
    public void testAndWithNullParse() throws Exception {
        Element e = FilterMockData.and(this.document, this.document, true);
        FilterMockData.propertyisNull(this.document, e);
        FilterMockData.propertyisNull(this.document, e);
        And and = (And)this.parse();
        Assert.assertEquals((long)2L, (long)and.getChildren().size());
        Assert.assertTrue((boolean)(and.getChildren().get(0) instanceof PropertyIsNull));
        Assert.assertTrue((boolean)(and.getChildren().get(1) instanceof PropertyIsNull));
    }

    @Test
    public void testAndWithNullEncode() throws Exception {
        FilterFactory f = FilterMockData.f;
        And and = f.and((Filter)FilterMockData.propertyIsNull(), (Filter)FilterMockData.propertyIsNull());
        Document dom = this.encode(and, OGC.And);
        Assert.assertEquals((long)2L, (long)this.getElementsByQName(dom, OGC.PropertyIsNull).getLength());
    }

    @Test
    public void testAndWithBetweenParse() throws Exception {
        Element e = FilterMockData.and(this.document, this.document, true);
        FilterMockData.propertyIsBetween(this.document, e);
        FilterMockData.propertyIsBetween(this.document, e);
        And and = (And)this.parse();
        Assert.assertEquals((long)2L, (long)and.getChildren().size());
        Assert.assertTrue((boolean)(and.getChildren().get(0) instanceof PropertyIsBetween));
        Assert.assertTrue((boolean)(and.getChildren().get(1) instanceof PropertyIsBetween));
    }

    @Test
    public void testAndWithBetweenEncode() throws Exception {
        FilterFactory f = FilterMockData.f;
        And and = f.and((Filter)FilterMockData.propertyIsBetween(), (Filter)FilterMockData.propertyIsBetween());
        Document dom = this.encode(and, OGC.And);
        Assert.assertEquals((long)2L, (long)this.getElementsByQName(dom, OGC.PropertyIsBetween).getLength());
    }
}

