/*
 *    GeoTools - The Open Source Java GIS Toolkit
 *    http://geotools.org
 *
 *    (C) 2002-2008, Open Source Geospatial Foundation (OSGeo)
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License as published by the Free Software Foundation;
 *    version 2.1 of the License.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 */
package org.geotools.filter.v1_0.capabilities;

import javax.xml.namespace.QName;
import org.geotools.api.filter.FilterFactory;
import org.geotools.api.filter.capability.ArithmeticOperators;
import org.geotools.api.filter.capability.ComparisonOperators;
import org.geotools.api.filter.capability.ScalarCapabilities;
import org.geotools.xsd.AbstractComplexBinding;
import org.geotools.xsd.ElementInstance;
import org.geotools.xsd.Node;

/**
 * Binding object for the type http://www.opengis.net/ogc:Scalar_CapabilitiesType.
 *
 * <p>
 *
 * <pre>
 *         <code>
 *  &lt;xsd:complexType name="Scalar_CapabilitiesType"&gt;
 *      &lt;xsd:choice maxOccurs="unbounded"&gt;
 *          &lt;xsd:element ref="ogc:Logical_Operators"/&gt;
 *          &lt;xsd:element name="Comparison_Operators" type="ogc:Comparison_OperatorsType"/&gt;
 *          &lt;xsd:element name="Arithmetic_Operators" type="ogc:Arithmetic_OperatorsType"/&gt;
 *      &lt;/xsd:choice&gt;
 *  &lt;/xsd:complexType&gt;
 *
 *          </code>
 *         </pre>
 *
 * @generated
 */
public class Scalar_CapabilitiesTypeBinding extends AbstractComplexBinding {
    FilterFactory factory;

    public Scalar_CapabilitiesTypeBinding(FilterFactory factory) {
        this.factory = factory;
    }

    /** @generated */
    @Override
    public QName getTarget() {
        return OGC.Scalar_CapabilitiesType;
    }

    /**
     *
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     *
     * @generated modifiable
     */
    @Override
    public Class getType() {
        return ScalarCapabilities.class;
    }

    /**
     *
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     *
     * @generated modifiable
     */
    @Override
    public Object parse(ElementInstance instance, Node node, Object value) throws Exception {
        // &lt;xsd:element ref="ogc:Logical_Operators"/&gt;
        boolean logical = node.hasChild("Logical_Operators") || node.hasChild("LogicalOperators"); /* 1.1 */

        // &lt;xsd:element name="Comparison_Operators" type="ogc:Comparison_OperatorsType"/&gt;
        ComparisonOperators comparison = node.getChildValue(ComparisonOperators.class);

        // &lt;xsd:element name="Arithmetic_Operators" type="ogc:Arithmetic_OperatorsType"/&gt;
        ArithmeticOperators arithmetic = node.getChildValue(ArithmeticOperators.class);

        return factory.scalarCapabilities(comparison, arithmetic, logical);
    }

    @Override
    public Object getProperty(Object object, QName name) throws Exception {
        ScalarCapabilities scalar = (ScalarCapabilities) object;

        if ((OGC.Logical_Operators.equals(name) || org.geotools.filter.v1_1.OGC.LogicalOperators.equals(name))
                && scalar.hasLogicalOperators()) {
            return new Object();
        }

        if ("Comparison_Operators".equals(name.getLocalPart())
                || "ComparisonOperators".equals(name.getLocalPart()) /* 1.1 */) {
            return scalar.getComparisonOperators();
        }

        if ("Arithmetic_Operators".equals(name.getLocalPart())
                || "ArithmeticOperators".equals(name.getLocalPart()) /* 1.1 */) {
            return scalar.getArithmeticOperators();
        }

        return null;
    }
}
