/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter.v1_1;

import java.sql.Time;
import java.sql.Timestamp;
import java.util.Date;
import org.geotools.api.filter.And;
import org.geotools.api.filter.Filter;
import org.geotools.api.filter.PropertyIsEqualTo;
import org.geotools.api.filter.spatial.Intersects;
import org.geotools.filter.v1_1.FilterMockData;
import org.geotools.filter.v1_1.FilterTestSupport;
import org.geotools.filter.v1_1.OGC;
import org.junit.Assert;
import org.junit.Test;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class FilterTypeBindingTest
extends FilterTestSupport {
    @Test
    public void testType() {
        Assert.assertEquals(Filter.class, (Object)this.binding(OGC.FilterType).getType());
    }

    @Test
    public void testExecutionMode() {
        Assert.assertEquals((long)2L, (long)this.binding(OGC.FilterType).getExecutionMode());
    }

    @Test
    public void testParseSpatial() throws Exception {
        Element filterElement = FilterMockData.element(this.document, this.document, OGC.Filter);
        FilterMockData.intersects(this.document, filterElement);
        Filter filter = (Filter)this.parse();
        Assert.assertTrue((boolean)(filter instanceof Intersects));
    }

    @Test
    public void testEncodeSpatial() throws Exception {
        Document doc = this.encode(FilterMockData.intersects(), OGC.Filter);
        Assert.assertEquals((Object)"ogc:Filter", (Object)doc.getDocumentElement().getNodeName());
        Assert.assertEquals((long)1L, (long)doc.getElementsByTagNameNS("http://www.opengis.net/ogc", "Intersects").getLength());
    }

    @Test
    public void testParseComparison() throws Exception {
        Element filterElement = FilterMockData.element(this.document, this.document, OGC.Filter);
        FilterMockData.propertyIsEqualTo(this.document, filterElement);
        Filter filter = (Filter)this.parse();
        Assert.assertTrue((boolean)(filter instanceof PropertyIsEqualTo));
    }

    @Test
    public void testEncodeComparison() throws Exception {
        Document doc = this.encode(FilterMockData.propertyIsEqualTo(), OGC.Filter);
        Assert.assertEquals((Object)"ogc:Filter", (Object)doc.getDocumentElement().getNodeName());
        Assert.assertEquals((long)1L, (long)doc.getElementsByTagNameNS("http://www.opengis.net/ogc", "PropertyIsEqualTo").getLength());
    }

    @Test
    public void testParseLogical() throws Exception {
        Element filterElement = FilterMockData.element(this.document, this.document, OGC.Filter);
        FilterMockData.and(this.document, filterElement);
        Filter filter = (Filter)this.parse();
        Assert.assertTrue((boolean)(filter instanceof And));
    }

    @Test
    public void testEncodeLogical() throws Exception {
        Document doc = this.encode(FilterMockData.and(), OGC.Filter);
        Assert.assertEquals((Object)"ogc:Filter", (Object)doc.getDocumentElement().getNodeName());
        Assert.assertEquals((long)1L, (long)doc.getElementsByTagNameNS("http://www.opengis.net/ogc", "And").getLength());
        doc = this.encode(FilterMockData.not(), OGC.Filter);
        Assert.assertEquals((Object)"ogc:Filter", (Object)doc.getDocumentElement().getNodeName());
        Assert.assertEquals((long)1L, (long)doc.getElementsByTagNameNS("http://www.opengis.net/ogc", "Not").getLength());
    }

    @Test
    public void testEncodeDateTimeLiterals() throws Exception {
        Date literal = new Date(1000000L);
        String expected = "1970-01-01T00:16:40Z";
        this.testEncodeLiteral(literal, expected);
        literal = new Timestamp(1000000L);
        expected = "1970-01-01T00:16:40Z";
        this.testEncodeLiteral(literal, expected);
        literal = new java.sql.Date(1000000L);
        expected = "1970-01-01Z";
        this.testEncodeLiteral(literal, expected);
        literal = new Time(1000000L);
        expected = "00:16:40Z";
        this.testEncodeLiteral(literal, expected);
    }

    private void testEncodeLiteral(Object literal, String expected) throws Exception {
        Document doc = this.encode(FilterMockData.literal(literal), OGC.Literal);
        Assert.assertEquals((Object)"ogc:Literal", (Object)doc.getDocumentElement().getNodeName());
        String actual = doc.getDocumentElement().getTextContent();
        Assert.assertEquals((Object)expected, (Object)actual);
    }
}

