/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.xsd.filter;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.geotools.api.feature.type.Name;
import org.geotools.api.filter.BinaryComparisonOperator;
import org.geotools.api.filter.BinaryLogicOperator;
import org.geotools.api.filter.Filter;
import org.geotools.api.filter.FilterFactory;
import org.geotools.api.filter.Id;
import org.geotools.api.filter.Not;
import org.geotools.api.filter.PropertyIsBetween;
import org.geotools.api.filter.PropertyIsLike;
import org.geotools.api.filter.PropertyIsNull;
import org.geotools.api.filter.expression.Expression;
import org.geotools.api.filter.expression.Function;
import org.geotools.api.filter.identity.Identifier;
import org.geotools.api.filter.spatial.BinarySpatialOperator;
import org.geotools.api.filter.temporal.BinaryTemporalOperator;
import org.geotools.feature.NameImpl;
import org.geotools.filter.FunctionFinder;
import org.geotools.xsd.Node;

public class FilterParsingUtils {
    public static Object Filter_getProperty(Object object, QName qName) {
        Filter filter = (Filter)object;
        String name = qName.getLocalPart();
        if ("spatialOps".equals(name) && filter instanceof BinarySpatialOperator) {
            return filter;
        }
        if ("comparisonOps".equals(name)) {
            if (filter instanceof BinaryComparisonOperator && !(filter instanceof BinarySpatialOperator)) {
                return filter;
            }
            if (filter instanceof PropertyIsLike || filter instanceof PropertyIsNull || filter instanceof PropertyIsBetween) {
                return filter;
            }
        }
        if ("logicOps".equals(name) && (filter instanceof BinaryLogicOperator || filter instanceof Not)) {
            return filter;
        }
        if ("temporalOps".equals(name) && filter instanceof BinaryTemporalOperator) {
            return filter;
        }
        if (filter instanceof Id && ("_Id".equals(name) || "FeatureId".equals(name))) {
            Id id = (Id)filter;
            return id.getIdentifiers();
        }
        return null;
    }

    public static List<Filter> BinaryLogicOperator_getChildFilters(Node node, FilterFactory factory) {
        List filters = node.getChildValues(Filter.class);
        if (filters.size() < 2) {
            List ids = node.getChildValues(Identifier.class);
            for (Identifier id : ids) {
                filters.add(factory.id(Collections.singleton(id)));
            }
            filters.addAll(FilterParsingUtils.parseExtendedOperators(node, factory));
        }
        return filters;
    }

    public static List<Filter> parseExtendedOperators(Node node, FilterFactory factory) {
        ArrayList<Filter> extOps = new ArrayList<Filter>();
        if (node.hasChild(Expression.class)) {
            Node n = node.getChild(Expression.class);
            NameImpl opName = new NameImpl(n.getComponent().getNamespace(), n.getComponent().getName());
            Filter extOp = FilterParsingUtils.lookupExtendedOperator((Name)opName, Arrays.asList((Expression)n.getValue()), factory);
            if (extOp != null) {
                extOps.add(extOp);
            }
        } else if (node.hasChild(Map.class)) {
            List children = node.getChildren(Map.class);
            for (Node n : children) {
                NameImpl opName = new NameImpl(n.getComponent().getNamespace(), n.getComponent().getName());
                Map map = (Map)n.getValue();
                ArrayList<Expression> expressions = new ArrayList<Expression>();
                for (Object o : map.values()) {
                    if (!(o instanceof Expression)) continue;
                    expressions.add((Expression)o);
                }
                Filter extOp = FilterParsingUtils.lookupExtendedOperator((Name)opName, expressions, factory);
                if (extOp == null) continue;
                extOps.add(extOp);
            }
        }
        return extOps;
    }

    static Filter lookupExtendedOperator(Name opName, List<Expression> expressions, FilterFactory factory) {
        FunctionFinder finder = new FunctionFinder(null);
        Function f = finder.findFunction(opName.getLocalPart(), expressions);
        return factory.equal((Expression)f, (Expression)factory.literal(true), true);
    }
}

