/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter.v1_1;

import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import javax.xml.parsers.DocumentBuilderFactory;
import org.geotools.api.filter.FilterFactory;
import org.geotools.api.filter.PropertyIsEqualTo;
import org.geotools.api.filter.expression.Expression;
import org.geotools.api.filter.expression.Literal;
import org.geotools.api.filter.expression.PropertyName;
import org.geotools.api.filter.spatial.DWithin;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.filter.v1_1.OGC;
import org.geotools.filter.v1_1.OGCConfiguration;
import org.geotools.xsd.Configuration;
import org.geotools.xsd.Encoder;
import org.geotools.xsd.Parser;
import org.junit.Assert;
import org.junit.Test;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class OGCFilterTest {
    @Test
    public void testEncode() throws Exception {
        FilterFactory f = CommonFactoryFinder.getFilterFactory(null);
        PropertyIsEqualTo filter = f.equal((Expression)f.property("testString"), (Expression)f.literal(2), false);
        File file = File.createTempFile("filter", "xml");
        file.deleteOnExit();
        try (BufferedOutputStream output = new BufferedOutputStream(new FileOutputStream(file));){
            Encoder encoder = new Encoder((Configuration)new OGCConfiguration());
            encoder.encode((Object)filter, OGC.PropertyIsEqualTo, (OutputStream)output);
            ((OutputStream)output).flush();
        }
        DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
        docFactory.setNamespaceAware(true);
        Document doc = docFactory.newDocumentBuilder().parse(file);
        Assert.assertEquals((Object)"ogc:PropertyIsEqualTo", (Object)doc.getDocumentElement().getNodeName());
        Assert.assertEquals((long)1L, (long)doc.getElementsByTagName("ogc:PropertyName").getLength());
        Assert.assertEquals((long)1L, (long)doc.getElementsByTagName("ogc:Literal").getLength());
        Element propertyName = (Element)doc.getElementsByTagName("ogc:PropertyName").item(0);
        Element literal = (Element)doc.getElementsByTagName("ogc:Literal").item(0);
        Assert.assertEquals((Object)"testString", (Object)propertyName.getFirstChild().getNodeValue());
        Assert.assertEquals((Object)"2", (Object)literal.getFirstChild().getNodeValue());
    }

    @Test
    public void testParse() throws Exception {
        Parser parser = new Parser((Configuration)new OGCConfiguration());
        try (InputStream in = this.getClass().getResourceAsStream("test1.xml");){
            if (in == null) {
                throw new FileNotFoundException(this.getClass().getResource("test1.xml").toExternalForm());
            }
            Object thing = parser.parse(in);
            Assert.assertEquals((long)0L, (long)parser.getValidationErrors().size());
            Assert.assertNotNull((Object)thing);
            Assert.assertTrue((boolean)(thing instanceof PropertyIsEqualTo));
            PropertyIsEqualTo equal = (PropertyIsEqualTo)thing;
            Assert.assertTrue((boolean)(equal.getExpression1() instanceof PropertyName));
            Assert.assertTrue((boolean)(equal.getExpression2() instanceof Literal));
            PropertyName name = (PropertyName)equal.getExpression1();
            Assert.assertEquals((Object)"testString", (Object)name.getPropertyName());
            Literal literal = (Literal)equal.getExpression2();
            Assert.assertEquals((Object)"2", (Object)literal.toString());
        }
    }

    @Test
    public void testDWithinParse() throws Exception {
        String xml = "<Filter><DWithin><PropertyName>the_geom</PropertyName><Point><coordinates>-74.817265,40.5296504</coordinates></Point><Distance units=\"km\">200</Distance></DWithin></Filter>";
        OGCConfiguration configuration = new OGCConfiguration();
        Parser parser = new Parser((Configuration)configuration);
        DWithin filter = (DWithin)parser.parse((InputStream)new ByteArrayInputStream(xml.getBytes()));
        Assert.assertNotNull((Object)filter);
        Assert.assertNotNull((Object)filter.getExpression1());
        PropertyName propName = (PropertyName)filter.getExpression1();
        String name = propName.getPropertyName();
        Assert.assertEquals((Object)"the_geom", (Object)name);
        Assert.assertNotNull((Object)filter.getExpression2());
        Literal geom = (Literal)filter.getExpression2();
        Assert.assertEquals((Object)"POINT (-74.817265 40.5296504)", (Object)geom.toString());
        Assert.assertTrue((filter.getDistance() > 0.0 ? 1 : 0) != 0);
        Double dist = filter.getDistance();
        Assert.assertEquals((double)200.0, (double)dist, (double)0.0);
        Assert.assertNotNull((Object)filter.getDistanceUnits());
        String unit = filter.getDistanceUnits();
        Assert.assertEquals((Object)"km", (Object)unit);
    }

    @Test
    public void testDWithinWithoutUnitsParse() throws Exception {
        String xml = "<Filter><DWithin><PropertyName>the_geom</PropertyName><Point><coordinates>-74.817265,40.5296504</coordinates></Point><Distance>200</Distance></DWithin></Filter>";
        OGCConfiguration configuration = new OGCConfiguration();
        Parser parser = new Parser((Configuration)configuration);
        DWithin filter = (DWithin)parser.parse((InputStream)new ByteArrayInputStream(xml.getBytes()));
        Assert.assertNotNull((Object)filter);
        Assert.assertTrue((filter.getDistance() > 0.0 ? 1 : 0) != 0);
        Double dist = filter.getDistance();
        Assert.assertEquals((double)200.0, (double)dist, (double)0.0);
        Assert.assertNull((Object)filter.getDistanceUnits());
    }

    @Test
    public void testBBOXValidateWithoutPropertyName() throws Exception {
        String xml = "<ogc:Filter xmlns:ogc='http://www.opengis.net/ogc'><ogc:BBOX><gml:Envelope xmlns:gml='http://www.opengis.net/gml'><gml:lowerCorner>36.986771000000005 -91.516129</gml:lowerCorner><gml:upperCorner>42.50936100000001 -87.507889</gml:upperCorner></gml:Envelope></ogc:BBOX></ogc:Filter>";
        Parser p = new Parser((Configuration)new OGCConfiguration());
        p.validate((Reader)new StringReader(xml));
        Assert.assertTrue((boolean)p.getValidationErrors().isEmpty());
    }
}

