/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter.v1_0;

import org.geotools.filter.v1_0.FilterMockData;
import org.geotools.filter.v1_0.FilterTestSupport;
import org.geotools.filter.v1_0.OGC;
import org.junit.Assert;
import org.junit.Test;
import org.opengis.filter.And;
import org.opengis.filter.Filter;
import org.opengis.filter.PropertyIsEqualTo;
import org.opengis.filter.spatial.Intersects;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class OGCFilterTypeBindingTest
extends FilterTestSupport {
    @Test
    public void testType() {
        Assert.assertEquals(Filter.class, (Object)this.binding(OGC.FilterType).getType());
    }

    @Test
    public void testExecutionMode() {
        Assert.assertEquals((long)2L, (long)this.binding(OGC.FilterType).getExecutionMode());
    }

    @Test
    public void testParseSpatial() throws Exception {
        Element filterElement = FilterMockData.element(this.document, this.document, OGC.Filter);
        FilterMockData.intersects(this.document, filterElement);
        Filter filter = (Filter)this.parse();
        Assert.assertTrue((boolean)(filter instanceof Intersects));
    }

    @Test
    public void testEncodeSpatial() throws Exception {
        Document doc = this.encode(FilterMockData.intersects(), OGC.Filter);
        Assert.assertEquals((Object)"ogc:Filter", (Object)doc.getDocumentElement().getNodeName());
        Assert.assertEquals((long)1L, (long)doc.getElementsByTagNameNS("http://www.opengis.net/ogc", "Intersects").getLength());
    }

    @Test
    public void testParseComparison() throws Exception {
        Element filterElement = FilterMockData.element(this.document, this.document, OGC.Filter);
        FilterMockData.propertyIsEqualTo(this.document, filterElement);
        Filter filter = (Filter)this.parse();
        Assert.assertTrue((boolean)(filter instanceof PropertyIsEqualTo));
    }

    @Test
    public void testEncodeComparison() throws Exception {
        Document doc = this.encode(FilterMockData.propertyIsEqualTo(), OGC.Filter);
        Assert.assertEquals((Object)"ogc:Filter", (Object)doc.getDocumentElement().getNodeName());
        Assert.assertEquals((long)1L, (long)doc.getElementsByTagNameNS("http://www.opengis.net/ogc", "PropertyIsEqualTo").getLength());
    }

    @Test
    public void testParseLogical() throws Exception {
        Element filterElement = FilterMockData.element(this.document, this.document, OGC.Filter);
        FilterMockData.and(this.document, filterElement);
        Filter filter = (Filter)this.parse();
        Assert.assertTrue((boolean)(filter instanceof And));
    }

    @Test
    public void testEncodeLogical() throws Exception {
        Document doc = this.encode(FilterMockData.and(), OGC.Filter);
        Assert.assertEquals((Object)"ogc:Filter", (Object)doc.getDocumentElement().getNodeName());
        Assert.assertEquals((long)1L, (long)doc.getElementsByTagNameNS("http://www.opengis.net/ogc", "And").getLength());
        doc = this.encode(FilterMockData.not(), OGC.Filter);
        Assert.assertEquals((Object)"ogc:Filter", (Object)doc.getDocumentElement().getNodeName());
        Assert.assertEquals((long)1L, (long)doc.getElementsByTagNameNS("http://www.opengis.net/ogc", "Not").getLength());
    }
}

