/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter.v1_1;

import org.geotools.filter.v1_1.FilterMockData;
import org.geotools.filter.v1_1.FilterTestSupport;
import org.geotools.filter.v1_1.OGC;
import org.junit.Assert;
import org.junit.Test;
import org.opengis.filter.expression.PropertyName;
import org.w3c.dom.Document;

public class PropertyNameTypeBindingTest
extends FilterTestSupport {
    @Test
    public void testParse() throws Exception {
        FilterMockData.propertyName(this.document, this.document);
        PropertyName propertyName = (PropertyName)this.parse();
        Assert.assertNotNull((Object)propertyName);
        Assert.assertEquals((Object)"foo", (Object)propertyName.getPropertyName());
        Assert.assertNotNull((Object)propertyName.getNamespaceContext());
    }

    @Test
    public void testParseWithPrefix() throws Exception {
        FilterMockData.propertyName("bar:foo", this.document, this.document);
        PropertyName propertyName = (PropertyName)this.parse();
        Assert.assertNotNull((Object)propertyName);
        Assert.assertEquals((Object)"bar:foo", (Object)propertyName.getPropertyName());
        Assert.assertNotNull((Object)propertyName.getNamespaceContext());
    }

    @Test
    public void testEncode() throws Exception {
        PropertyName propertyName = FilterMockData.propertyName("foo");
        Document dom = this.encode(propertyName, OGC.PropertyName);
        Assert.assertEquals((Object)"foo", (Object)dom.getDocumentElement().getFirstChild().getNodeValue());
    }
}

