/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter.v1_0;

import javax.xml.namespace.QName;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.filter.v1_0.OGC;
import org.geotools.gml2.GML;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.opengis.filter.And;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterFactory2;
import org.opengis.filter.Not;
import org.opengis.filter.Or;
import org.opengis.filter.PropertyIsBetween;
import org.opengis.filter.PropertyIsEqualTo;
import org.opengis.filter.PropertyIsGreaterThan;
import org.opengis.filter.PropertyIsGreaterThanOrEqualTo;
import org.opengis.filter.PropertyIsLessThan;
import org.opengis.filter.PropertyIsLessThanOrEqualTo;
import org.opengis.filter.PropertyIsLike;
import org.opengis.filter.PropertyIsNotEqualTo;
import org.opengis.filter.PropertyIsNull;
import org.opengis.filter.expression.Add;
import org.opengis.filter.expression.Divide;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.expression.Function;
import org.opengis.filter.expression.Literal;
import org.opengis.filter.expression.Multiply;
import org.opengis.filter.expression.PropertyName;
import org.opengis.filter.expression.Subtract;
import org.opengis.filter.identity.FeatureId;
import org.opengis.filter.spatial.BBOX;
import org.opengis.filter.spatial.Beyond;
import org.opengis.filter.spatial.Contains;
import org.opengis.filter.spatial.Crosses;
import org.opengis.filter.spatial.DWithin;
import org.opengis.filter.spatial.Disjoint;
import org.opengis.filter.spatial.Equals;
import org.opengis.filter.spatial.Intersects;
import org.opengis.filter.spatial.Overlaps;
import org.opengis.filter.spatial.Touches;
import org.opengis.filter.spatial.Within;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class FilterMockData {
    static FilterFactory2 f = (FilterFactory2)CommonFactoryFinder.getFilterFactory(null);

    static Element propertyName(Document document, Node parent) {
        return FilterMockData.propertyName("foo", document, parent);
    }

    static Element propertyName(String property, Document document, Node parent) {
        Element propertyName = FilterMockData.element(document, parent, OGC.PropertyName);
        propertyName.appendChild(document.createTextNode(property));
        return propertyName;
    }

    static PropertyName propertyName() {
        return FilterMockData.propertyName("foo");
    }

    private static Expression propertyNameIsFunc() {
        return f.function("strToLowerCase", new Expression[]{FilterMockData.propertyName("foo")});
    }

    static PropertyName propertyName(String property) {
        return f.property(property);
    }

    static Element literal(Document document, Node parent) {
        return FilterMockData.literal("foo", document, parent);
    }

    static Element literal(String value, Document document, Node parent) {
        Element literal = FilterMockData.element(document, parent, OGC.Literal);
        literal.appendChild(document.createTextNode(value));
        return literal;
    }

    static Literal literal() {
        return FilterMockData.literal("foo");
    }

    static Literal literal(Object value) {
        return f.literal(value);
    }

    static Element propertyIsEqualTo(Document document, Node parent) {
        return FilterMockData.binaryComparisonOp(document, parent, OGC.PropertyIsEqualTo);
    }

    static PropertyIsEqualTo propertyIsEqualTo() {
        return f.equals((Expression)FilterMockData.propertyName(), (Expression)FilterMockData.literal());
    }

    static Element propertyIsNotEqualTo(Document document, Node parent) {
        return FilterMockData.binaryComparisonOp(document, parent, OGC.PropertyIsNotEqualTo);
    }

    static PropertyIsNotEqualTo propertyIsNotEqualTo() {
        return f.notEqual((Expression)FilterMockData.propertyName(), (Expression)FilterMockData.literal(), false);
    }

    static Element propertyIsLessThan(Document document, Node parent) {
        return FilterMockData.binaryComparisonOp(document, parent, OGC.PropertyIsLessThan);
    }

    static PropertyIsLessThan propertyIsLessThan() {
        return f.less((Expression)FilterMockData.propertyName(), (Expression)FilterMockData.literal());
    }

    static Element propertyIsLessThanOrEqualTo(Document document, Node parent) {
        return FilterMockData.binaryComparisonOp(document, parent, OGC.PropertyIsLessThanOrEqualTo);
    }

    static PropertyIsLessThanOrEqualTo propertyIsLessThanOrEqualTo() {
        return f.lessOrEqual((Expression)FilterMockData.propertyName(), (Expression)FilterMockData.literal());
    }

    static Element propertyIsGreaterThan(Document document, Node parent) {
        return FilterMockData.binaryComparisonOp(document, parent, OGC.PropertyIsGreaterThan);
    }

    static PropertyIsGreaterThan propertyIsGreaterThan() {
        return f.greater((Expression)FilterMockData.propertyName(), (Expression)FilterMockData.literal());
    }

    static PropertyIsGreaterThan propertyFuncIsGreaterThan() {
        return f.greater(FilterMockData.propertyNameIsFunc(), (Expression)FilterMockData.literal());
    }

    static Element propertyIsGreaterThanOrEqualTo(Document document, Node parent) {
        return FilterMockData.binaryComparisonOp(document, parent, OGC.PropertyIsGreaterThanOrEqualTo);
    }

    static PropertyIsGreaterThanOrEqualTo propertyIsGreaterThanOrEqualTo() {
        return f.greaterOrEqual((Expression)FilterMockData.propertyName(), (Expression)FilterMockData.literal());
    }

    static Element binaryComparisonOp(Document document, Node parent, QName name) {
        Element binaryComparisonOp = FilterMockData.element(document, parent, name);
        FilterMockData.propertyName(document, binaryComparisonOp);
        FilterMockData.literal(document, binaryComparisonOp);
        return binaryComparisonOp;
    }

    static PropertyIsBetween propertyIsBetween() {
        return f.between((Expression)f.property("foo"), (Expression)f.literal(1), (Expression)f.literal(2));
    }

    static Element propertyIsBetween(Document document, Node parent) {
        Element between = FilterMockData.element(document, parent, OGC.PropertyIsBetween);
        FilterMockData.propertyName(document, between);
        Element lower = FilterMockData.element(document, between, new QName("http://www.opengis.net/ogc", "LowerBoundary"));
        FilterMockData.literal(document, lower);
        Element upper = FilterMockData.element(document, between, new QName("http://www.opengis.net/ogc", "UpperBoundary"));
        FilterMockData.literal(document, upper);
        return between;
    }

    static PropertyIsNull propertyIsNull() {
        return f.isNull((Expression)FilterMockData.propertyName());
    }

    static Element propertyisNull(Document document, Node parent) {
        Element isNull = FilterMockData.element(document, parent, OGC.PropertyIsNull);
        FilterMockData.propertyName(document, isNull);
        return isNull;
    }

    static PropertyIsLike propertyIsLike() {
        return f.like((Expression)FilterMockData.propertyName(), "foo", "x", "y", "z");
    }

    static PropertyIsLike propertyIsLike2() {
        PropertyIsLike filter = f.like(FilterMockData.propertyNameIsFunc(), "foo", "x", "y", "z");
        return filter;
    }

    static Element propertyIsLike(Document document, Node parent) {
        Element isLike = FilterMockData.element(document, parent, OGC.PropertyIsLike);
        FilterMockData.propertyName(document, isLike);
        FilterMockData.literal(document, isLike);
        isLike.setAttribute("wildCard", "x");
        isLike.setAttribute("singleChar", "y");
        isLike.setAttribute("escape", "z");
        return isLike;
    }

    static Element and(Document document, Node parent) {
        return FilterMockData.and(document, parent, false);
    }

    static Element and(Document document, Node parent, boolean empty) {
        Element and = FilterMockData.element(document, parent, OGC.And);
        if (!empty) {
            FilterMockData.propertyIsEqualTo(document, and);
            FilterMockData.propertyIsNotEqualTo(document, and);
        }
        return and;
    }

    static And and() {
        return f.and((Filter)FilterMockData.propertyIsEqualTo(), (Filter)FilterMockData.propertyIsNotEqualTo());
    }

    static Element or(Document document, Node parent) {
        Element or = FilterMockData.element(document, parent, OGC.Or);
        FilterMockData.propertyIsEqualTo(document, or);
        FilterMockData.propertyIsNotEqualTo(document, or);
        return or;
    }

    static Or or() {
        return f.or((Filter)FilterMockData.propertyIsEqualTo(), (Filter)FilterMockData.propertyIsNotEqualTo());
    }

    static Not not() {
        return f.not((Filter)FilterMockData.propertyIsEqualTo());
    }

    static Element not(Document document, Node parent) {
        Element not = FilterMockData.element(document, parent, OGC.Not);
        FilterMockData.propertyIsEqualTo(document, not);
        return not;
    }

    static Not notIsNull() {
        return f.not((Filter)FilterMockData.propertyIsNull());
    }

    static Beyond beyond() {
        return f.beyond((Expression)f.property("the_geom"), (Expression)f.literal((Object)FilterMockData.geometry()), 1.0, "m");
    }

    static DWithin dwithin() {
        return f.dwithin((Expression)f.property("the_geom"), (Expression)f.literal((Object)FilterMockData.geometry()), 1.0, "m");
    }

    static Element beyond(Document document, Node parent) {
        return FilterMockData.distanceBufferOperator(document, parent, OGC.Beyond);
    }

    static Element dwithin(Document document, Node parent) {
        return FilterMockData.distanceBufferOperator(document, parent, OGC.DWithin);
    }

    static Element distanceBufferOperator(Document document, Node parent, QName name) {
        Element doperator = FilterMockData.binarySpatialOperator(document, parent, name);
        FilterMockData.distance(document, doperator);
        return doperator;
    }

    static Element distance(Document document, Node parent) {
        Element distance = FilterMockData.element(document, parent, OGC.Distance);
        distance.appendChild(document.createTextNode("1.0"));
        distance.setAttribute("units", "m");
        return distance;
    }

    static Element contains(Document document, Node parent) {
        return FilterMockData.binarySpatialOperator(document, parent, OGC.Contains);
    }

    static Contains contains() {
        return f.contains((Expression)f.property("the_geom"), (Expression)f.literal((Object)FilterMockData.geometry()));
    }

    static Element crosses(Document document, Node parent) {
        return FilterMockData.binarySpatialOperator(document, parent, OGC.Crosses);
    }

    static Crosses crosses() {
        return f.crosses((Expression)f.property("the_geom"), (Expression)f.literal((Object)FilterMockData.geometry()));
    }

    static Element disjoint(Document document, Node parent) {
        return FilterMockData.binarySpatialOperator(document, parent, OGC.Disjoint);
    }

    static Disjoint disjoint() {
        return f.disjoint((Expression)f.property("the_geom"), (Expression)f.literal((Object)FilterMockData.geometry()));
    }

    static Element equals(Document document, Node parent) {
        return FilterMockData.binarySpatialOperator(document, parent, OGC.Equals);
    }

    static Equals equals() {
        return f.equal((Expression)f.property("the_geom"), (Expression)f.literal((Object)FilterMockData.geometry()));
    }

    static Element intersects(Document document, Node parent) {
        return FilterMockData.binarySpatialOperator(document, parent, OGC.Intersects);
    }

    static Intersects intersects() {
        return f.intersects((Expression)f.property("the_geom"), (Expression)f.literal((Object)FilterMockData.geometry()));
    }

    static Element overlaps(Document document, Node parent) {
        return FilterMockData.binarySpatialOperator(document, parent, OGC.Overlaps);
    }

    static Overlaps overlaps() {
        return f.overlaps((Expression)f.property("the_geom"), (Expression)f.literal((Object)FilterMockData.geometry()));
    }

    static Element touches(Document document, Node parent) {
        return FilterMockData.binarySpatialOperator(document, parent, OGC.Touches);
    }

    static Touches touches() {
        return f.touches((Expression)f.property("the_geom"), (Expression)f.literal((Object)FilterMockData.geometry()));
    }

    static Element within(Document document, Node parent) {
        return FilterMockData.binarySpatialOperator(document, parent, OGC.Within);
    }

    static Within within() {
        return f.within((Expression)f.property("the_geom"), (Expression)f.literal((Object)FilterMockData.geometry()));
    }

    static Within withinWithFunction() {
        return f.within((Expression)f.property("the_geom"), (Expression)FilterMockData.function());
    }

    static Element withinWithFunction(Document document, Node parent) {
        Element within = FilterMockData.element(document, parent, OGC.Within);
        FilterMockData.propertyName(document, within);
        FilterMockData.function(document, within);
        return within;
    }

    static Element binarySpatialOperator(Document document, Node parent, QName name) {
        Element spatial = FilterMockData.element(document, parent, name);
        FilterMockData.propertyName(document, spatial);
        FilterMockData.geometry(document, spatial);
        return spatial;
    }

    static Geometry geometry() {
        return new GeometryFactory().createPoint(new Coordinate(1.0, 1.0));
    }

    static Element geometry(Document document, Node parent) {
        Element geometry = FilterMockData.element(document, parent, GML.Point);
        Element pos = FilterMockData.element(document, geometry, GML.coord);
        Element x = FilterMockData.element(document, pos, new QName("http://www.opengis.net/gml", "X"));
        x.appendChild(document.createTextNode("1"));
        Element y = FilterMockData.element(document, pos, new QName("http://www.opengis.net/gml", "Y"));
        y.appendChild(document.createTextNode("1"));
        return geometry;
    }

    static Element envelope(Document document, Node parent) {
        Element envelope = FilterMockData.element(document, parent, GML.Box);
        Element lower = FilterMockData.element(document, envelope, GML.coord);
        Element x = FilterMockData.element(document, lower, new QName("http://www.opengis.net/gml", "X"));
        x.appendChild(document.createTextNode("0"));
        Element y = FilterMockData.element(document, lower, new QName("http://www.opengis.net/gml", "Y"));
        y.appendChild(document.createTextNode("0"));
        Element upper = FilterMockData.element(document, envelope, GML.coord);
        x = FilterMockData.element(document, upper, new QName("http://www.opengis.net/gml", "X"));
        x.appendChild(document.createTextNode("1"));
        y = FilterMockData.element(document, upper, new QName("http://www.opengis.net/gml", "Y"));
        y.appendChild(document.createTextNode("1"));
        envelope.setAttribute("srsName", "EPSG:4326");
        return envelope;
    }

    static Element add(Document document, Node parent) {
        return FilterMockData.binaryExpression(document, parent, OGC.Add);
    }

    static Add add() {
        return f.add((Expression)f.literal(1), (Expression)f.literal(2));
    }

    static Element sub(Document document, Node parent) {
        return FilterMockData.binaryExpression(document, parent, OGC.Sub);
    }

    static Subtract sub() {
        return f.subtract((Expression)f.literal(1), (Expression)f.literal(2));
    }

    static Element mul(Document document, Node parent) {
        return FilterMockData.binaryExpression(document, parent, OGC.Mul);
    }

    static Multiply mul() {
        return f.multiply((Expression)f.literal(1), (Expression)f.literal(2));
    }

    static Element div(Document document, Node parent) {
        return FilterMockData.binaryExpression(document, parent, OGC.Div);
    }

    static Divide div() {
        return f.divide((Expression)f.literal(1), (Expression)f.literal(2));
    }

    static Element binaryExpression(Document document, Node parent, QName name) {
        Element binaryExpression = FilterMockData.element(document, parent, name);
        FilterMockData.literal(document, binaryExpression);
        FilterMockData.literal(document, binaryExpression);
        return binaryExpression;
    }

    static FeatureId featureId() {
        return f.featureId("foo");
    }

    static Element featureId(Document document, Node parent) {
        Element featureId = FilterMockData.element(document, parent, OGC.FeatureId);
        featureId.setAttribute("fid", "foo");
        return featureId;
    }

    static Function function() {
        return f.function("min", new Expression[]{f.property("arg1"), f.literal(2)});
    }

    static Element function(Document document, Node parent) {
        Element function = FilterMockData.element(document, parent, OGC.Function);
        function.setAttributeNS("", "name", "min");
        FilterMockData.propertyName(document, function);
        FilterMockData.literal(document, function);
        return function;
    }

    static BBOX bbox() {
        return f.bbox("foo", 0.0, 0.0, 1.0, 1.0, "EPSG:4326");
    }

    static Element bbox(Document document, Node parent) {
        Element bbox = FilterMockData.element(document, parent, OGC.BBOX);
        FilterMockData.propertyName(document, bbox);
        FilterMockData.envelope(document, bbox);
        return bbox;
    }

    static Element element(Document document, Node parent, QName name) {
        Element element = document.createElementNS(name.getNamespaceURI(), name.getLocalPart());
        if (parent != null) {
            parent.appendChild(element);
        }
        return element;
    }
}

