/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter.v1_1.capabilities;

import java.util.ArrayList;
import javax.xml.namespace.QName;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.filter.v1_1.OGC;
import org.opengis.filter.FilterFactory;
import org.opengis.filter.capability.ArithmeticOperators;
import org.opengis.filter.capability.ComparisonOperators;
import org.opengis.filter.capability.FilterCapabilities;
import org.opengis.filter.capability.FunctionName;
import org.opengis.filter.capability.Functions;
import org.opengis.filter.capability.GeometryOperand;
import org.opengis.filter.capability.IdCapabilities;
import org.opengis.filter.capability.Operator;
import org.opengis.filter.capability.ScalarCapabilities;
import org.opengis.filter.capability.SpatialCapabilities;
import org.opengis.filter.capability.SpatialOperator;
import org.opengis.filter.capability.SpatialOperators;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class FilterMockData {
    static FilterFactory ff = CommonFactoryFinder.getFilterFactory(null);

    static Element functionName(Document document, Node parent) {
        return FilterMockData.functionName(document, parent, "foo", 2);
    }

    static Element functionName(Document document, Node parent, String name, int nargs) {
        Element function = FilterMockData.element(document, parent, new QName("http://www.opengis.net/ogc", "FunctionName"));
        function.setAttributeNS("", "nArgs", "" + nargs);
        function.appendChild(document.createTextNode(name));
        return function;
    }

    static Element functionNames(Document document, Node parent) {
        Element functionNames = FilterMockData.element(document, parent, new QName("http://www.opengis.net/ogc", "FunctionNames"));
        FilterMockData.functionName(document, functionNames, "foo", 2);
        FilterMockData.functionName(document, functionNames, "bar", 3);
        return functionNames;
    }

    static Element functions(Document document, Node parent) {
        Element functions = FilterMockData.element(document, parent, new QName("http://www.opengis.net/ogc", "Functions"));
        FilterMockData.functionNames(document, functions);
        return functions;
    }

    static FunctionName functionName() {
        return FilterMockData.functionName("foo", 2);
    }

    static FunctionName functionName(String name, int args) {
        return ff.functionName(name, args);
    }

    static FunctionName[] functionNames() {
        return new FunctionName[]{FilterMockData.functionName("foo", 2), FilterMockData.functionName("bar", 3)};
    }

    static Functions functions() {
        return ff.functions(FilterMockData.functionNames());
    }

    static Element arithmetic(Document document, Node parent, boolean simple) {
        Element arithmetic = FilterMockData.element(document, parent, new QName("http://www.opengis.net/ogc", "ArithmeticOperators"));
        if (simple) {
            FilterMockData.element(document, arithmetic, OGC.SimpleArithmetic);
        }
        FilterMockData.functions(document, arithmetic);
        return arithmetic;
    }

    static Element arithmetic(Document document, Node parent) {
        return FilterMockData.arithmetic(document, parent, true);
    }

    static ArithmeticOperators arithmetic() {
        return FilterMockData.arithmetic(true);
    }

    static ArithmeticOperators arithmetic(boolean simple) {
        return ff.arithmeticOperators(simple, FilterMockData.functions());
    }

    static Element comparisonOperator(Document document, Node parent, String name) {
        Element operator = FilterMockData.element(document, parent, new QName("http://www.opengis.net/ogc", "ComparisonOperator"));
        operator.appendChild(document.createTextNode(name));
        return operator;
    }

    static Operator comparisonOperator(String name) {
        return ff.operator(name);
    }

    static Element comparison(Document document, Node parent) {
        return FilterMockData.comparison(document, parent, true);
    }

    static Element comparison(Document document, Node parent, boolean simple) {
        Element comparison = FilterMockData.element(document, parent, new QName("http://www.opengis.net/ogc", "ComparisonOperators"));
        if (simple) {
            FilterMockData.comparisonOperator(document, comparison, "LessThan");
            FilterMockData.comparisonOperator(document, comparison, "GreaterThan");
            FilterMockData.comparisonOperator(document, comparison, "LessThanOrEqualTo");
            FilterMockData.comparisonOperator(document, comparison, "GreaterThanOrEqualTo");
            FilterMockData.comparisonOperator(document, comparison, "EqualTo");
            FilterMockData.comparisonOperator(document, comparison, "NotEqualTo");
        }
        FilterMockData.comparisonOperator(document, comparison, "Like");
        FilterMockData.comparisonOperator(document, comparison, "Between");
        FilterMockData.comparisonOperator(document, comparison, "NullCheck");
        return comparison;
    }

    static ComparisonOperators comparison() {
        return FilterMockData.comparison(true);
    }

    static ComparisonOperators comparison(boolean simple) {
        ArrayList<Operator> o = new ArrayList<Operator>();
        if (simple) {
            o.add(ff.operator("LessThan"));
            o.add(ff.operator("LessThanOrEqualTo"));
            o.add(ff.operator("GreaterThan"));
            o.add(ff.operator("GreaterThanOrEqualTo"));
            o.add(ff.operator("EqualTo"));
            o.add(ff.operator("NotEqualTo"));
        }
        o.add(ff.operator("Like"));
        o.add(ff.operator("Between"));
        o.add(ff.operator("NullCheck"));
        return ff.comparisonOperators(o.toArray(new Operator[o.size()]));
    }

    static Element scalarCapabilities(Document document, Node parent) {
        return FilterMockData.scalarCapabilities(document, parent, true);
    }

    static Element scalarCapabilities(Document document, Node parent, boolean logical) {
        Element scalar = FilterMockData.element(document, parent, new QName("http://www.opengis.net/ogc", "Scalar_Capabilities"));
        if (logical) {
            FilterMockData.element(document, scalar, OGC.LogicalOperators);
        }
        FilterMockData.comparison(document, scalar);
        FilterMockData.arithmetic(document, scalar);
        return scalar;
    }

    static ScalarCapabilities scalarCapabilities() {
        return FilterMockData.scalarCapabilities(true);
    }

    static ScalarCapabilities scalarCapabilities(boolean logical) {
        return ff.scalarCapabilities(FilterMockData.comparison(), FilterMockData.arithmetic(), logical);
    }

    static Element geometryOperand(Document document, Node parent, String name) {
        Element operand = FilterMockData.element(document, parent, new QName("http://www.opengis.net/ogc", "GeometryOperand"));
        operand.appendChild(document.createTextNode("gml:" + name));
        return operand;
    }

    static Element geometryOperands(Document document, Node parent) {
        Element operands = FilterMockData.element(document, parent, new QName("http://www.opengis.net/ogc", "GeometryOperands"));
        FilterMockData.geometryOperand(document, operands, "Envelope");
        FilterMockData.geometryOperand(document, operands, "Point");
        return operands;
    }

    static GeometryOperand[] geometryOperands() {
        return new GeometryOperand[]{GeometryOperand.Envelope, GeometryOperand.Point};
    }

    static Element spatialOperator(Document document, Node parent, String name) {
        Element operator = FilterMockData.element(document, parent, new QName("http://www.opengis.net/ogc", "SpatialOperator"));
        operator.setAttributeNS("", "name", name);
        return operator;
    }

    static SpatialOperator spatialOperator(String name) {
        return ff.spatialOperator(name, null);
    }

    static Element spatial(Document document, Node parent) {
        Element spatial = FilterMockData.element(document, parent, new QName("http://www.opengis.net/ogc", "SpatialOperators"));
        FilterMockData.spatialOperator(document, spatial, "BBOX");
        FilterMockData.spatialOperator(document, spatial, "Equals");
        FilterMockData.spatialOperator(document, spatial, "Disjoint");
        FilterMockData.spatialOperator(document, spatial, "Intersect");
        FilterMockData.spatialOperator(document, spatial, "Touches");
        FilterMockData.spatialOperator(document, spatial, "Contains");
        FilterMockData.spatialOperator(document, spatial, "Crosses");
        FilterMockData.spatialOperator(document, spatial, "Within");
        FilterMockData.spatialOperator(document, spatial, "Overlaps");
        FilterMockData.spatialOperator(document, spatial, "Beyond");
        FilterMockData.spatialOperator(document, spatial, "DWithin");
        return spatial;
    }

    static SpatialOperators spatial() {
        ArrayList<SpatialOperator> o = new ArrayList<SpatialOperator>();
        o.add(FilterMockData.spatialOperator("BBOX"));
        o.add(FilterMockData.spatialOperator("Equals"));
        o.add(FilterMockData.spatialOperator("Disjoint"));
        o.add(FilterMockData.spatialOperator("Intersect"));
        o.add(FilterMockData.spatialOperator("Touches"));
        o.add(FilterMockData.spatialOperator("Crosses"));
        o.add(FilterMockData.spatialOperator("Within"));
        o.add(FilterMockData.spatialOperator("Contains"));
        o.add(FilterMockData.spatialOperator("Overlaps"));
        o.add(FilterMockData.spatialOperator("Beyond"));
        o.add(FilterMockData.spatialOperator("DWithin"));
        return ff.spatialOperators(o.toArray(new SpatialOperator[o.size()]));
    }

    static SpatialCapabilities spatialCapabilities() {
        return ff.spatialCapabilities(null, FilterMockData.spatial());
    }

    static Element spatialCapabilities(Document document, Node parent) {
        Element spatial = FilterMockData.element(document, parent, new QName("http://www.opengis.net/ogc", "Spatial_Capabilities"));
        FilterMockData.spatial(document, spatial);
        return spatial;
    }

    static Element idCapabilities(Document document, Node parent) {
        Element id = FilterMockData.element(document, parent, new QName("http://www.opengis.net/ogc", "Id_Capabilities"));
        FilterMockData.element(document, id, OGC.EID);
        FilterMockData.element(document, id, OGC.FID);
        return id;
    }

    static IdCapabilities idCapabilities() {
        return ff.idCapabilities(true, true);
    }

    static FilterCapabilities capabilities() {
        return ff.capabilities("1.0.0", FilterMockData.scalarCapabilities(), FilterMockData.spatialCapabilities(), FilterMockData.idCapabilities());
    }

    static Element capabilities(Document document, Node parent) {
        Element capabilities = FilterMockData.element(document, parent, OGC.Filter_Capabilities);
        capabilities.setAttributeNS("", "version", "1.0.0");
        FilterMockData.scalarCapabilities(document, capabilities);
        FilterMockData.spatialCapabilities(document, capabilities);
        FilterMockData.idCapabilities(document, capabilities);
        return capabilities;
    }

    static Element element(Document document, Node parent, QName name) {
        Element element = document.createElementNS(name.getNamespaceURI(), name.getLocalPart());
        if (parent != null) {
            parent.appendChild(element);
        }
        return element;
    }
}

