/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter.v1_0;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import org.geotools.filter.v1_0.FilterMockData;
import org.geotools.filter.v1_0.FilterTestSupport;
import org.geotools.filter.v1_0.OGC;
import org.geotools.filter.v1_0.OGCConfiguration;
import org.geotools.xsd.Configuration;
import org.geotools.xsd.Parser;
import org.junit.Assert;
import org.junit.Test;
import org.opengis.filter.Filter;
import org.opengis.filter.PropertyIsLike;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class OGCPropertyIsLikeTypeBindingTest
extends FilterTestSupport {
    @Test
    public void testType() {
        Assert.assertEquals(PropertyIsLike.class, (Object)this.binding(OGC.PropertyIsLikeType).getType());
    }

    @Test
    public void testExecutionMode() {
        Assert.assertEquals((long)2L, (long)this.binding(OGC.PropertyIsLikeType).getExecutionMode());
    }

    @Test
    public void testParse() throws Exception {
        FilterMockData.propertyIsLike(this.document, this.document);
        PropertyIsLike isLike = (PropertyIsLike)this.parse();
        Assert.assertNotNull((Object)isLike.getExpression());
        Assert.assertNotNull((Object)isLike.getLiteral());
        Assert.assertEquals((Object)"x", (Object)isLike.getWildCard());
        Assert.assertEquals((Object)"y", (Object)isLike.getSingleChar());
        Assert.assertEquals((Object)"z", (Object)isLike.getEscape());
    }

    @Test
    public void testEncode() throws Exception {
        Document doc = this.encode(FilterMockData.propertyIsLike(), OGC.PropertyIsLike);
        Element pn = this.getElementByQName(doc, OGC.PropertyName);
        Assert.assertNotNull((Object)pn);
        Assert.assertEquals((Object)"foo", (Object)pn.getFirstChild().getNodeValue());
        Element l = this.getElementByQName(doc, OGC.Literal);
        Assert.assertEquals((Object)"foo", (Object)l.getFirstChild().getNodeValue());
        Assert.assertEquals((Object)"x", (Object)doc.getDocumentElement().getAttribute("wildCard"));
        Assert.assertEquals((Object)"y", (Object)doc.getDocumentElement().getAttribute("singleChar"));
        Assert.assertEquals((Object)"z", (Object)doc.getDocumentElement().getAttribute("escape"));
    }

    @Test
    public void testEncodeAsFilter() throws Exception {
        Document doc = this.encode(FilterMockData.propertyIsLike(), OGC.Filter);
        Assert.assertEquals((long)1L, (long)doc.getDocumentElement().getElementsByTagNameNS("http://www.opengis.net/ogc", OGC.PropertyName.getLocalPart()).getLength());
        Assert.assertEquals((long)1L, (long)doc.getDocumentElement().getElementsByTagNameNS("http://www.opengis.net/ogc", OGC.Literal.getLocalPart()).getLength());
        Element e = this.getElementByQName(doc, OGC.PropertyIsLike);
        Assert.assertEquals((Object)"x", (Object)e.getAttribute("wildCard"));
        Assert.assertEquals((Object)"y", (Object)e.getAttribute("singleChar"));
        Assert.assertEquals((Object)"z", (Object)e.getAttribute("escape"));
    }

    @Test
    public void testEncodeWithFunctionAsFilter() throws Exception {
        Document doc = this.encode(FilterMockData.propertyIsLike2(), OGC.Filter);
        NodeList property = doc.getDocumentElement().getElementsByTagNameNS("http://www.opengis.net/ogc", OGC.Function.getLocalPart());
        Assert.assertEquals((long)1L, (long)property.getLength());
        Assert.assertNotNull((Object)property.item(0).getChildNodes());
        Assert.assertNotSame((Object)"", (Object)property.item(0).getNodeValue());
        Assert.assertEquals((long)1L, (long)doc.getDocumentElement().getElementsByTagNameNS("http://www.opengis.net/ogc", OGC.Literal.getLocalPart()).getLength());
        Element e = this.getElementByQName(doc, OGC.PropertyIsLike);
        Assert.assertEquals((Object)"x", (Object)e.getAttribute("wildCard"));
        Assert.assertEquals((Object)"y", (Object)e.getAttribute("singleChar"));
        Assert.assertEquals((Object)"z", (Object)e.getAttribute("escape"));
        Element p = this.getElementByQName(e, OGC.Function);
        Assert.assertEquals((Object)"strToLowerCase", (Object)p.getAttribute("name"));
        Element pn = this.getElementByQName(p, OGC.PropertyName);
        Assert.assertEquals((Object)"foo", (Object)pn.getTextContent());
    }

    @Test
    public void testBackwardLikeFilter() throws Exception {
        String f = "<ogc:Filter  xmlns:ogc=\"http://www.opengis.net/ogc\"><ogc:PropertyIsLike wildCard=\"*\" singleChar=\"#\" escapeChar=\"!\">\n<ogc:Literal>M*</ogc:Literal>\n<ogc:PropertyName>gml:name</ogc:PropertyName>\n</ogc:PropertyIsLike></ogc:Filter>";
        OGCConfiguration configuration = new OGCConfiguration();
        Parser parser = new Parser((Configuration)configuration);
        Filter filter = (Filter)parser.parse((InputStream)new ByteArrayInputStream(f.getBytes()));
        Document doc = this.encode(filter, OGC.Filter);
        Assert.assertEquals((long)1L, (long)doc.getDocumentElement().getElementsByTagNameNS("http://www.opengis.net/ogc", OGC.PropertyName.getLocalPart()).getLength());
        Assert.assertEquals((long)1L, (long)doc.getDocumentElement().getElementsByTagNameNS("http://www.opengis.net/ogc", OGC.Literal.getLocalPart()).getLength());
        Element e = this.getElementByQName(doc, OGC.PropertyIsLike);
        Assert.assertEquals((Object)"*", (Object)e.getAttribute("wildCard"));
        Assert.assertEquals((Object)"#", (Object)e.getAttribute("singleChar"));
        Assert.assertEquals((Object)"!", (Object)e.getAttribute("escape"));
    }

    @Test
    public void testBackwardLikeFilterWithFunction() throws Exception {
        String f = "<ogc:Filter  xmlns:ogc=\"http://www.opengis.net/ogc\"><ogc:PropertyIsLike wildCard=\"*\" singleChar=\"#\" escapeChar=\"!\">\n<ogc:Literal>M*</ogc:Literal>\n<ogc:Function name=\"strToLowerCase\"><ogc:PropertyName>gml:name</ogc:PropertyName></ogc:Function>\n</ogc:PropertyIsLike></ogc:Filter>";
        OGCConfiguration configuration = new OGCConfiguration();
        Parser parser = new Parser((Configuration)configuration);
        Filter filter = (Filter)parser.parse((InputStream)new ByteArrayInputStream(f.getBytes()));
        Document doc = this.encode(filter, OGC.Filter);
        Assert.assertEquals((long)1L, (long)doc.getDocumentElement().getElementsByTagNameNS("http://www.opengis.net/ogc", OGC.PropertyName.getLocalPart()).getLength());
        Assert.assertEquals((long)1L, (long)doc.getDocumentElement().getElementsByTagNameNS("http://www.opengis.net/ogc", OGC.Literal.getLocalPart()).getLength());
        Element e = this.getElementByQName(doc, OGC.PropertyIsLike);
        Assert.assertEquals((Object)"*", (Object)e.getAttribute("wildCard"));
        Assert.assertEquals((Object)"#", (Object)e.getAttribute("singleChar"));
        Assert.assertEquals((Object)"!", (Object)e.getAttribute("escape"));
    }
}

