/*
 *    GeoTools - The Open Source Java GIS Toolkit
 *    http://geotools.org
 *
 *    (C) 2002-2008, Open Source Geospatial Foundation (OSGeo)
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License as published by the Free Software Foundation;
 *    version 2.1 of the License.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 */
package org.geotools.filter.v1_0.capabilities;

import javax.xml.namespace.QName;
import org.geotools.xsd.AbstractComplexBinding;
import org.geotools.xsd.ElementInstance;
import org.geotools.xsd.Node;
import org.opengis.filter.FilterFactory;
import org.opengis.filter.capability.ArithmeticOperators;
import org.opengis.filter.capability.Functions;

/**
 * Binding object for the type http://www.opengis.net/ogc:Arithmetic_OperatorsType.
 *
 * <p>
 *
 * <pre>
 *         <code>
 *  &lt;xsd:complexType name="Arithmetic_OperatorsType"&gt;
 *      &lt;xsd:choice maxOccurs="unbounded"&gt;
 *          &lt;xsd:element ref="ogc:Simple_Arithmetic"/&gt;
 *          &lt;xsd:element name="Functions" type="ogc:FunctionsType"/&gt;
 *      &lt;/xsd:choice&gt;
 *  &lt;/xsd:complexType&gt;
 *
 *          </code>
 *         </pre>
 *
 * @generated
 */
public class Arithmetic_OperatorsTypeBinding extends AbstractComplexBinding {
    FilterFactory factory;

    public Arithmetic_OperatorsTypeBinding(FilterFactory factory) {
        this.factory = factory;
    }

    /** @generated */
    @Override
    public QName getTarget() {
        return OGC.Arithmetic_OperatorsType;
    }

    /**
     *
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     *
     * @generated modifiable
     */
    @Override
    public Class getType() {
        return ArithmeticOperators.class;
    }

    /**
     *
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     *
     * @generated modifiable
     */
    @Override
    public Object parse(ElementInstance instance, Node node, Object value) throws Exception {
        // &lt;xsd:element ref="ogc:Simple_Arithmetic"/&gt;
        boolean simpleArithmetic =
                node.hasChild("Simple_Arithmetic") || node.hasChild("SimpleArithmetic"); // 1.1

        // &lt;xsd:element name="Functions" type="ogc:FunctionsType"/&gt;
        Functions functions = node.getChildValue(Functions.class);

        return factory.arithmeticOperators(simpleArithmetic, functions);
    }

    @Override
    public Object getProperty(Object object, QName name) throws Exception {
        ArithmeticOperators arithmetic = (ArithmeticOperators) object;

        if ((name.equals(OGC.Simple_Arithmetic)
                        || name.equals(org.geotools.filter.v1_1.OGC.SimpleArithmetic))
                && arithmetic.hasSimpleArithmetic()) {
            return new Object();
        }

        if (name.getLocalPart().equals("Functions")) {
            return arithmetic.getFunctions();
        }

        return null;
    }
}
