/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter.v1_1;

import java.sql.Time;
import java.sql.Timestamp;
import java.util.Date;
import org.geotools.filter.v1_1.FilterMockData;
import org.geotools.filter.v1_1.FilterTestSupport;
import org.geotools.filter.v1_1.OGC;
import org.opengis.filter.And;
import org.opengis.filter.Filter;
import org.opengis.filter.PropertyIsEqualTo;
import org.opengis.filter.spatial.Intersects;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class FilterTypeBindingTest
extends FilterTestSupport {
    public void testType() {
        FilterTypeBindingTest.assertEquals(Filter.class, (Object)this.binding(OGC.FilterType).getType());
    }

    public void testExecutionMode() {
        FilterTypeBindingTest.assertEquals((int)2, (int)this.binding(OGC.FilterType).getExecutionMode());
    }

    public void testParseSpatial() throws Exception {
        Element filterElement = FilterMockData.element(this.document, this.document, OGC.Filter);
        FilterMockData.intersects(this.document, filterElement);
        Filter filter = (Filter)this.parse();
        FilterTypeBindingTest.assertTrue((boolean)(filter instanceof Intersects));
    }

    public void testEncodeSpatial() throws Exception {
        Document doc = this.encode(FilterMockData.intersects(), OGC.Filter);
        FilterTypeBindingTest.assertEquals((String)"ogc:Filter", (String)doc.getDocumentElement().getNodeName());
        FilterTypeBindingTest.assertEquals((int)1, (int)doc.getElementsByTagNameNS("http://www.opengis.net/ogc", "Intersects").getLength());
    }

    public void testParseComparison() throws Exception {
        Element filterElement = FilterMockData.element(this.document, this.document, OGC.Filter);
        FilterMockData.propertyIsEqualTo(this.document, filterElement);
        Filter filter = (Filter)this.parse();
        FilterTypeBindingTest.assertTrue((boolean)(filter instanceof PropertyIsEqualTo));
    }

    public void testEncodeComparison() throws Exception {
        Document doc = this.encode(FilterMockData.propertyIsEqualTo(), OGC.Filter);
        FilterTypeBindingTest.assertEquals((String)"ogc:Filter", (String)doc.getDocumentElement().getNodeName());
        FilterTypeBindingTest.assertEquals((int)1, (int)doc.getElementsByTagNameNS("http://www.opengis.net/ogc", "PropertyIsEqualTo").getLength());
    }

    public void testParseLogical() throws Exception {
        Element filterElement = FilterMockData.element(this.document, this.document, OGC.Filter);
        FilterMockData.and(this.document, filterElement);
        Filter filter = (Filter)this.parse();
        FilterTypeBindingTest.assertTrue((boolean)(filter instanceof And));
    }

    public void testEncodeLogical() throws Exception {
        Document doc = this.encode(FilterMockData.and(), OGC.Filter);
        FilterTypeBindingTest.assertEquals((String)"ogc:Filter", (String)doc.getDocumentElement().getNodeName());
        FilterTypeBindingTest.assertEquals((int)1, (int)doc.getElementsByTagNameNS("http://www.opengis.net/ogc", "And").getLength());
        doc = this.encode(FilterMockData.not(), OGC.Filter);
        FilterTypeBindingTest.assertEquals((String)"ogc:Filter", (String)doc.getDocumentElement().getNodeName());
        FilterTypeBindingTest.assertEquals((int)1, (int)doc.getElementsByTagNameNS("http://www.opengis.net/ogc", "Not").getLength());
    }

    public void testEncodeDateTimeLiterals() throws Exception {
        Date literal = new Date(1000000L);
        String expected = "1970-01-01T00:16:40Z";
        this.testEncodeLiteral(literal, expected);
        literal = new Timestamp(1000000L);
        expected = "1970-01-01T00:16:40Z";
        this.testEncodeLiteral(literal, expected);
        literal = new java.sql.Date(1000000L);
        expected = "1970-01-01Z";
        this.testEncodeLiteral(literal, expected);
        literal = new Time(1000000L);
        expected = "00:16:40Z";
        this.testEncodeLiteral(literal, expected);
    }

    private void testEncodeLiteral(Object literal, String expected) throws Exception {
        Document doc = this.encode(FilterMockData.literal(literal), OGC.Literal);
        FilterTypeBindingTest.assertEquals((String)"ogc:Literal", (String)doc.getDocumentElement().getNodeName());
        String actual = doc.getDocumentElement().getTextContent();
        FilterTypeBindingTest.assertEquals((String)expected, (String)actual);
    }
}

