/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter.v1_0;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import org.geotools.filter.v1_0.FilterMockData;
import org.geotools.filter.v1_0.FilterTestSupport;
import org.geotools.filter.v1_0.OGC;
import org.geotools.filter.v1_0.OGCConfiguration;
import org.geotools.xsd.Configuration;
import org.geotools.xsd.Parser;
import org.opengis.filter.Filter;
import org.opengis.filter.PropertyIsLike;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class OGCPropertyIsLikeTypeBindingTest
extends FilterTestSupport {
    public void testType() {
        OGCPropertyIsLikeTypeBindingTest.assertEquals(PropertyIsLike.class, (Object)this.binding(OGC.PropertyIsLikeType).getType());
    }

    public void testExecutionMode() {
        OGCPropertyIsLikeTypeBindingTest.assertEquals((int)2, (int)this.binding(OGC.PropertyIsLikeType).getExecutionMode());
    }

    public void testParse() throws Exception {
        FilterMockData.propertyIsLike(this.document, this.document);
        PropertyIsLike isLike = (PropertyIsLike)this.parse();
        OGCPropertyIsLikeTypeBindingTest.assertNotNull((Object)isLike.getExpression());
        OGCPropertyIsLikeTypeBindingTest.assertNotNull((Object)isLike.getLiteral());
        OGCPropertyIsLikeTypeBindingTest.assertEquals((String)"x", (String)isLike.getWildCard());
        OGCPropertyIsLikeTypeBindingTest.assertEquals((String)"y", (String)isLike.getSingleChar());
        OGCPropertyIsLikeTypeBindingTest.assertEquals((String)"z", (String)isLike.getEscape());
    }

    public void testEncode() throws Exception {
        Document doc = this.encode(FilterMockData.propertyIsLike(), OGC.PropertyIsLike);
        Element pn = this.getElementByQName(doc, OGC.PropertyName);
        OGCPropertyIsLikeTypeBindingTest.assertNotNull((Object)pn);
        OGCPropertyIsLikeTypeBindingTest.assertEquals((String)"foo", (String)pn.getFirstChild().getNodeValue());
        Element l = this.getElementByQName(doc, OGC.Literal);
        OGCPropertyIsLikeTypeBindingTest.assertEquals((String)"foo", (String)l.getFirstChild().getNodeValue());
        OGCPropertyIsLikeTypeBindingTest.assertEquals((String)"x", (String)doc.getDocumentElement().getAttribute("wildCard"));
        OGCPropertyIsLikeTypeBindingTest.assertEquals((String)"y", (String)doc.getDocumentElement().getAttribute("singleChar"));
        OGCPropertyIsLikeTypeBindingTest.assertEquals((String)"z", (String)doc.getDocumentElement().getAttribute("escape"));
    }

    public void testEncodeAsFilter() throws Exception {
        Document doc = this.encode(FilterMockData.propertyIsLike(), OGC.Filter);
        OGCPropertyIsLikeTypeBindingTest.assertEquals((int)1, (int)doc.getDocumentElement().getElementsByTagNameNS("http://www.opengis.net/ogc", OGC.PropertyName.getLocalPart()).getLength());
        OGCPropertyIsLikeTypeBindingTest.assertEquals((int)1, (int)doc.getDocumentElement().getElementsByTagNameNS("http://www.opengis.net/ogc", OGC.Literal.getLocalPart()).getLength());
        Element e = this.getElementByQName(doc, OGC.PropertyIsLike);
        OGCPropertyIsLikeTypeBindingTest.assertEquals((String)"x", (String)e.getAttribute("wildCard"));
        OGCPropertyIsLikeTypeBindingTest.assertEquals((String)"y", (String)e.getAttribute("singleChar"));
        OGCPropertyIsLikeTypeBindingTest.assertEquals((String)"z", (String)e.getAttribute("escape"));
    }

    public void testEncodeWithFunctionAsFilter() throws Exception {
        Document doc = this.encode(FilterMockData.propertyIsLike2(), OGC.Filter);
        NodeList property = doc.getDocumentElement().getElementsByTagNameNS("http://www.opengis.net/ogc", OGC.Function.getLocalPart());
        OGCPropertyIsLikeTypeBindingTest.assertEquals((int)1, (int)property.getLength());
        OGCPropertyIsLikeTypeBindingTest.assertNotNull((Object)property.item(0).getChildNodes());
        OGCPropertyIsLikeTypeBindingTest.assertNotSame((Object)"", (Object)property.item(0).getNodeValue());
        OGCPropertyIsLikeTypeBindingTest.assertEquals((int)1, (int)doc.getDocumentElement().getElementsByTagNameNS("http://www.opengis.net/ogc", OGC.Literal.getLocalPart()).getLength());
        Element e = this.getElementByQName(doc, OGC.PropertyIsLike);
        OGCPropertyIsLikeTypeBindingTest.assertEquals((String)"x", (String)e.getAttribute("wildCard"));
        OGCPropertyIsLikeTypeBindingTest.assertEquals((String)"y", (String)e.getAttribute("singleChar"));
        OGCPropertyIsLikeTypeBindingTest.assertEquals((String)"z", (String)e.getAttribute("escape"));
        Element p = this.getElementByQName(e, OGC.Function);
        OGCPropertyIsLikeTypeBindingTest.assertEquals((String)"strToLowerCase", (String)p.getAttribute("name"));
        Element pn = this.getElementByQName(p, OGC.PropertyName);
        OGCPropertyIsLikeTypeBindingTest.assertEquals((String)"foo", (String)pn.getTextContent());
    }

    public void testBackwardLikeFilter() throws Exception {
        String f = "<ogc:Filter  xmlns:ogc=\"http://www.opengis.net/ogc\"><ogc:PropertyIsLike wildCard=\"*\" singleChar=\"#\" escapeChar=\"!\">\n<ogc:Literal>M*</ogc:Literal>\n<ogc:PropertyName>gml:name</ogc:PropertyName>\n</ogc:PropertyIsLike></ogc:Filter>";
        OGCConfiguration configuration = new OGCConfiguration();
        Parser parser = new Parser((Configuration)configuration);
        Filter filter = (Filter)parser.parse((InputStream)new ByteArrayInputStream(f.getBytes()));
        Document doc = this.encode(filter, OGC.Filter);
        OGCPropertyIsLikeTypeBindingTest.assertEquals((int)1, (int)doc.getDocumentElement().getElementsByTagNameNS("http://www.opengis.net/ogc", OGC.PropertyName.getLocalPart()).getLength());
        OGCPropertyIsLikeTypeBindingTest.assertEquals((int)1, (int)doc.getDocumentElement().getElementsByTagNameNS("http://www.opengis.net/ogc", OGC.Literal.getLocalPart()).getLength());
        Element e = this.getElementByQName(doc, OGC.PropertyIsLike);
        OGCPropertyIsLikeTypeBindingTest.assertEquals((String)"*", (String)e.getAttribute("wildCard"));
        OGCPropertyIsLikeTypeBindingTest.assertEquals((String)"#", (String)e.getAttribute("singleChar"));
        OGCPropertyIsLikeTypeBindingTest.assertEquals((String)"!", (String)e.getAttribute("escape"));
    }

    public void testBackwardLikeFilterWithFunction() throws Exception {
        String f = "<ogc:Filter  xmlns:ogc=\"http://www.opengis.net/ogc\"><ogc:PropertyIsLike wildCard=\"*\" singleChar=\"#\" escapeChar=\"!\">\n<ogc:Literal>M*</ogc:Literal>\n<ogc:Function name=\"strToLowerCase\"><ogc:PropertyName>gml:name</ogc:PropertyName></ogc:Function>\n</ogc:PropertyIsLike></ogc:Filter>";
        OGCConfiguration configuration = new OGCConfiguration();
        Parser parser = new Parser((Configuration)configuration);
        Filter filter = (Filter)parser.parse((InputStream)new ByteArrayInputStream(f.getBytes()));
        Document doc = this.encode(filter, OGC.Filter);
        OGCPropertyIsLikeTypeBindingTest.assertEquals((int)1, (int)doc.getDocumentElement().getElementsByTagNameNS("http://www.opengis.net/ogc", OGC.PropertyName.getLocalPart()).getLength());
        OGCPropertyIsLikeTypeBindingTest.assertEquals((int)1, (int)doc.getDocumentElement().getElementsByTagNameNS("http://www.opengis.net/ogc", OGC.Literal.getLocalPart()).getLength());
        Element e = this.getElementByQName(doc, OGC.PropertyIsLike);
        OGCPropertyIsLikeTypeBindingTest.assertEquals((String)"*", (String)e.getAttribute("wildCard"));
        OGCPropertyIsLikeTypeBindingTest.assertEquals((String)"#", (String)e.getAttribute("singleChar"));
        OGCPropertyIsLikeTypeBindingTest.assertEquals((String)"!", (String)e.getAttribute("escape"));
    }
}

