/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter.v1_0;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import junit.framework.TestCase;
import org.geotools.filter.v1_0.OGCConfiguration;
import org.geotools.xsd.Configuration;
import org.geotools.xsd.Parser;
import org.opengis.filter.Filter;
import org.opengis.filter.PropertyIsEqualTo;
import org.opengis.filter.expression.Literal;
import org.opengis.filter.expression.PropertyName;
import org.opengis.filter.spatial.DWithin;

public class OGCFilterTest
extends TestCase {
    Parser parser;

    protected void setUp() throws Exception {
        super.setUp();
        OGCConfiguration configuration = new OGCConfiguration();
        this.parser = new Parser((Configuration)configuration);
    }

    public void testRun() throws Exception {
        Object thing = this.parser.parse(((Object)((Object)this)).getClass().getResourceAsStream("test1.xml"));
        OGCFilterTest.assertNotNull((Object)thing);
        OGCFilterTest.assertTrue((boolean)(thing instanceof PropertyIsEqualTo));
        PropertyIsEqualTo equal = (PropertyIsEqualTo)thing;
        OGCFilterTest.assertTrue((boolean)(equal.getExpression1() instanceof PropertyName));
        OGCFilterTest.assertTrue((boolean)(equal.getExpression2() instanceof Literal));
        PropertyName name = (PropertyName)equal.getExpression1();
        OGCFilterTest.assertEquals((String)"testString", (String)name.getPropertyName());
        Literal literal = (Literal)equal.getExpression2();
        OGCFilterTest.assertEquals((String)"2", (String)literal.toString());
    }

    public void testLax() throws Exception {
        String xml = "<Filter>  <PropertyIsEqualTo>    <PropertyName>foo</PropertyName>    <Literal>bar</Literal>  </PropertyIsEqualTo></Filter>";
        Parser parser = new Parser((Configuration)new OGCConfiguration());
        parser.setStrict(false);
        Filter filter = (Filter)parser.parse((InputStream)new ByteArrayInputStream(xml.getBytes()));
        OGCFilterTest.assertNotNull((Object)filter);
    }

    public void testLiteralWithEntity() throws Exception {
        String xml = "<Filter>  <PropertyIsEqualTo>    <PropertyName>foo</PropertyName>    <Literal>bar &gt; 10 and &lt; 20</Literal>  </PropertyIsEqualTo></Filter>";
        Parser parser = new Parser((Configuration)new OGCConfiguration());
        parser.setStrict(false);
        Filter filter = (Filter)parser.parse((InputStream)new ByteArrayInputStream(xml.getBytes()));
        OGCFilterTest.assertNotNull((Object)filter);
        PropertyIsEqualTo equal = (PropertyIsEqualTo)filter;
        PropertyName pn = (PropertyName)equal.getExpression1();
        OGCFilterTest.assertEquals((String)"foo", (String)pn.getPropertyName());
        Literal literal = (Literal)equal.getExpression2();
        OGCFilterTest.assertEquals((Object)"bar > 10 and < 20", (Object)literal.getValue());
    }

    public void testDWithinParse() throws Exception {
        String xml = "<Filter><DWithin><PropertyName>the_geom</PropertyName><Point><coordinates>-74.817265,40.5296504</coordinates></Point><Distance units=\"km\">200</Distance></DWithin></Filter>";
        OGCConfiguration configuration = new OGCConfiguration();
        Parser parser = new Parser((Configuration)configuration);
        DWithin filter = (DWithin)parser.parse((InputStream)new ByteArrayInputStream(xml.getBytes()));
        OGCFilterTest.assertNotNull((Object)filter);
        OGCFilterTest.assertNotNull((Object)filter.getExpression1());
        PropertyName propName = (PropertyName)filter.getExpression1();
        String name = propName.getPropertyName();
        OGCFilterTest.assertEquals((String)"the_geom", (String)name);
        OGCFilterTest.assertNotNull((Object)filter.getExpression2());
        Literal geom = (Literal)filter.getExpression2();
        OGCFilterTest.assertEquals((String)"POINT (-74.817265 40.5296504)", (String)geom.toString());
        OGCFilterTest.assertTrue((filter.getDistance() > 0.0 ? 1 : 0) != 0);
        Double dist = filter.getDistance();
        OGCFilterTest.assertEquals((Object)200.0, (Object)dist);
        OGCFilterTest.assertNotNull((Object)filter.getDistanceUnits());
        String unit = filter.getDistanceUnits();
        OGCFilterTest.assertEquals((String)"km", (String)unit);
    }
}

