/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter.v1_1;

import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import javax.xml.parsers.DocumentBuilderFactory;
import junit.framework.TestCase;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.filter.v1_1.OGC;
import org.geotools.filter.v1_1.OGCConfiguration;
import org.geotools.xsd.Configuration;
import org.geotools.xsd.Encoder;
import org.geotools.xsd.Parser;
import org.opengis.filter.FilterFactory;
import org.opengis.filter.PropertyIsEqualTo;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.expression.Literal;
import org.opengis.filter.expression.PropertyName;
import org.opengis.filter.spatial.DWithin;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class OGCFilterTest
extends TestCase {
    public void testEncode() throws Exception {
        FilterFactory f = CommonFactoryFinder.getFilterFactory(null);
        PropertyIsEqualTo filter = f.equal((Expression)f.property("testString"), (Expression)f.literal(2), false);
        File file = File.createTempFile("filter", "xml");
        file.deleteOnExit();
        BufferedOutputStream output = new BufferedOutputStream(new FileOutputStream(file));
        Encoder encoder = new Encoder((Configuration)new OGCConfiguration());
        encoder.encode((Object)filter, OGC.PropertyIsEqualTo, (OutputStream)output);
        ((OutputStream)output).flush();
        ((OutputStream)output).close();
        DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
        docFactory.setNamespaceAware(true);
        Document doc = docFactory.newDocumentBuilder().parse(file);
        OGCFilterTest.assertEquals((String)"ogc:PropertyIsEqualTo", (String)doc.getDocumentElement().getNodeName());
        OGCFilterTest.assertEquals((int)1, (int)doc.getElementsByTagName("ogc:PropertyName").getLength());
        OGCFilterTest.assertEquals((int)1, (int)doc.getElementsByTagName("ogc:Literal").getLength());
        Element propertyName = (Element)doc.getElementsByTagName("ogc:PropertyName").item(0);
        Element literal = (Element)doc.getElementsByTagName("ogc:Literal").item(0);
        OGCFilterTest.assertEquals((String)"testString", (String)propertyName.getFirstChild().getNodeValue());
        OGCFilterTest.assertEquals((String)"2", (String)literal.getFirstChild().getNodeValue());
    }

    public void testParse() throws Exception {
        Parser parser = new Parser((Configuration)new OGCConfiguration());
        InputStream in = ((Object)((Object)this)).getClass().getResourceAsStream("test1.xml");
        if (in == null) {
            throw new FileNotFoundException(((Object)((Object)this)).getClass().getResource("test1.xml").toExternalForm());
        }
        Object thing = parser.parse(in);
        OGCFilterTest.assertEquals((int)0, (int)parser.getValidationErrors().size());
        OGCFilterTest.assertNotNull((Object)thing);
        OGCFilterTest.assertTrue((boolean)(thing instanceof PropertyIsEqualTo));
        PropertyIsEqualTo equal = (PropertyIsEqualTo)thing;
        OGCFilterTest.assertTrue((boolean)(equal.getExpression1() instanceof PropertyName));
        OGCFilterTest.assertTrue((boolean)(equal.getExpression2() instanceof Literal));
        PropertyName name = (PropertyName)equal.getExpression1();
        OGCFilterTest.assertEquals((String)"testString", (String)name.getPropertyName());
        Literal literal = (Literal)equal.getExpression2();
        OGCFilterTest.assertEquals((String)"2", (String)literal.toString());
    }

    public void testDWithinParse() throws Exception {
        String xml = "<Filter><DWithin><PropertyName>the_geom</PropertyName><Point><coordinates>-74.817265,40.5296504</coordinates></Point><Distance units=\"km\">200</Distance></DWithin></Filter>";
        OGCConfiguration configuration = new OGCConfiguration();
        Parser parser = new Parser((Configuration)configuration);
        DWithin filter = (DWithin)parser.parse((InputStream)new ByteArrayInputStream(xml.getBytes()));
        OGCFilterTest.assertNotNull((Object)filter);
        OGCFilterTest.assertNotNull((Object)filter.getExpression1());
        PropertyName propName = (PropertyName)filter.getExpression1();
        String name = propName.getPropertyName();
        OGCFilterTest.assertEquals((String)"the_geom", (String)name);
        OGCFilterTest.assertNotNull((Object)filter.getExpression2());
        Literal geom = (Literal)filter.getExpression2();
        OGCFilterTest.assertEquals((String)"POINT (-74.817265 40.5296504)", (String)geom.toString());
        OGCFilterTest.assertTrue((filter.getDistance() > 0.0 ? 1 : 0) != 0);
        Double dist = filter.getDistance();
        OGCFilterTest.assertEquals((Object)200.0, (Object)dist);
        OGCFilterTest.assertNotNull((Object)filter.getDistanceUnits());
        String unit = filter.getDistanceUnits();
        OGCFilterTest.assertEquals((String)"km", (String)unit);
    }

    public void testBBOXValidateWithoutPropertyName() throws Exception {
        String xml = "<ogc:Filter xmlns:ogc='http://www.opengis.net/ogc'><ogc:BBOX><gml:Envelope xmlns:gml='http://www.opengis.net/gml'><gml:lowerCorner>36.986771000000005 -91.516129</gml:lowerCorner><gml:upperCorner>42.50936100000001 -87.507889</gml:upperCorner></gml:Envelope></ogc:BBOX></ogc:Filter>";
        Parser p = new Parser((Configuration)new OGCConfiguration());
        p.validate((Reader)new StringReader(xml));
        OGCFilterTest.assertTrue((boolean)p.getValidationErrors().isEmpty());
    }
}

